/**
 * $Id: EnumerationParameterImpl.java 132580 2012-08-22 21:41:28Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import java.util.Vector;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.InvalidParameterException;

/**
 * A classe <code>EnumerationParameterImpl</code> implementa um valutype
 * <code>EnumerationParameter</code>
 * 
 * @author Tecgraf
 */
public class EnumerationParameterImpl extends EnumerationParameter {
  /**
   * Vetor para armazenar os itens
   */
  private Vector<EnumerationItem> vectorItems = new Vector<EnumerationItem>();

  /**
   * Construtor padro.
   */
  public EnumerationParameterImpl() {
    this.selectedId = "";
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param selectedId id do item selecionado
   */
  public EnumerationParameterImpl(String selectedId) {
    this.selectedId = selectedId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() throws ConversionToTextException {
    if (this.selectedId == null) {
      throw new ConversionToTextException();
    }
    return this.selectedId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return EnumerationParameterHelper.id();
  }

  /**
   * Adiciona um item aos valores disponveis (usando na construo do
   * parmetro).
   * 
   * @param item item a ser adicionado
   */
  public void addItem(EnumerationItem item) {
    vectorItems.add(item);
    this.items = vectorItems.toArray(new EnumerationItem[vectorItems.size()]);
  }

  /**
   * Coloca o valor informado como o valor selecionado para o parmetro.
   * 
   * @param selectedId identificador do valor selecionado
   * 
   * @throws InvalidParameterException caso o valor seja invlido
   */
  public void setSelectedItem(String selectedId)
    throws InvalidParameterException {
    if (validateItem(selectedId)) {
      this.selectedId = selectedId;
    }
    else {
      throw new InvalidParameterException();
    }
  }

  /**
   * Verifica se o valor informado  valido ( uma das opes disponveis).
   * 
   * @param itemId identificador do item
   * 
   * @return true se o valor for vlido e false caso contrrio
   */
  private boolean validateItem(String itemId) {
    if (this.items == null) {
      return false;
    }
    if (this.items.length == 0) {
      return false;
    }
    for (EnumerationItem item : this.items) {
      if (item.id.equals(itemId)) {
        return true;
      }
    }
    return false;
  }
}