/**
 * $Id: IntegerListParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;

/**
 * A classe <code>IntegerListParameterImpl</code> implementa um valutype
 * <code>IntegerListParameter</code>
 * 
 * @author Tecgraf
 */
public class IntegerListParameterImpl extends IntegerListParameter {

  /**
   * Construtor padro.
   */
  public IntegerListParameterImpl() {
    this.valueList = new IntegerParameterImpl[0];
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param valueList lista de valores
   */
  public IntegerListParameterImpl(int[] valueList) {
    this.valueList = new IntegerParameterImpl[valueList.length];
    for (int i = 0; i < valueList.length; i++) {
      this.valueList[i] = new IntegerParameterImpl(valueList[i]);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() throws ConversionToTextException {
    return ListParameter.convertListToText(valueList);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return IntegerListParameterHelper.id();
  }
}