/**
 * $Id: TableParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.IParameterValue;

/**
 * A classe <code>TableParameterImpl</code> implementa um valutype
 * <code>TableParameter</code>
 * 
 * @author Tecgraf
 */
public class TableParameterImpl extends TableParameter {

  /**
   * Caractere que define o incio da tabela.
   */
  private static final char START_TABLE_CHAR = '{';

  /**
   * Caractere que define o incio de uma linha.
   */
  private static final char START_ROW_CHAR = '{';

  /**
   * Caractere que separa as colunas.
   */
  private static final char ROW_SEPARATOR_CHAR = ',';

  /**
   * Caractere que separa os elementos de uma linha.
   */
  private static final char ELEMENT_SEPARATOR_CHAR = ',';

  /**
   * Caractere que define o fim da tabela.
   */
  private static final char END_TABLE_CHAR = '}';

  /**
   * Caractere que define o fim de uma linha.
   */
  private static final char END_ROW_CHAR = '}';

  /**
   * Construtor padro.
   */
  public TableParameterImpl() {
    this.rows = new IParameterValue[0][0];
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param columns valor do parmetro
   */
  public TableParameterImpl(IParameterValue[][] columns) {
    this.rows = columns;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() throws ConversionToTextException {

    StringBuffer tableAsText = new StringBuffer();

    tableAsText.append(START_TABLE_CHAR);
    for (int i = 0; i < this.rows.length; i++) {
      tableAsText.append(START_ROW_CHAR);
      for (int j = 0; j < this.rows[i].length; j++) {
        tableAsText.append(this.rows[i][j].convertToText());
        if (j < this.rows[i].length - 1) {
          tableAsText.append(ELEMENT_SEPARATOR_CHAR);
        }
      }
      tableAsText.append(END_ROW_CHAR);
      if (i < this.rows.length - 1) {
        tableAsText.append(ROW_SEPARATOR_CHAR);
      }
    }
    tableAsText.append(END_TABLE_CHAR);

    return tableAsText.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return TableParameterHelper.id();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void addRow(IParameterValue[] row) {
    IParameterValue[][] newRows = new IParameterValue[this.rows.length + 1][];

    for (int i = 0; i < this.rows.length; i++) {
      newRows[i] = this.rows[i];
    }

    newRows[this.rows.length] = row;
    this.rows = newRows;
  }
}