/**
 * $Id: TextListParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;

/**
 * A classe <code>TextListParameterImpl</code> implementa um valutype
 * <code>TextListParameter</code>
 * 
 * @author Tecgraf
 */
public class TextListParameterImpl extends TextListParameter {

  /**
   * Construtor padro.
   */
  public TextListParameterImpl() {
    this.valueList = new TextParameterImpl[0];
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param valueList lista de valores
   */
  public TextListParameterImpl(String[] valueList) {
    this.valueList = new TextParameterImpl[valueList.length];
    for (int i = 0; i < valueList.length; i++) {
      this.valueList[i] = new TextParameterImpl(valueList[i]);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() throws ConversionToTextException {
    return ListParameter.convertListToText(valueList);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return TextListParameterHelper.id();
  }
}