/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.IParameterValue;
import tecgraf.openbus.algorithmservice.v1_1.parameters.TableParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.TableParameterHelper;

public class TableParameterImpl
extends TableParameter {
    private static final char START_TABLE_CHAR = '{';
    private static final char START_ROW_CHAR = '{';
    private static final char ROW_SEPARATOR_CHAR = ',';
    private static final char ELEMENT_SEPARATOR_CHAR = ',';
    private static final char END_TABLE_CHAR = '}';
    private static final char END_ROW_CHAR = '}';

    public TableParameterImpl() {
        this.rows = new IParameterValue[0][0];
    }

    public TableParameterImpl(IParameterValue[][] columns) {
        this.rows = columns;
    }

    @Override
    public String convertToText() throws ConversionToTextException {
        StringBuffer tableAsText = new StringBuffer();
        tableAsText.append('{');
        for (int i = 0; i < this.rows.length; ++i) {
            tableAsText.append('{');
            for (int j = 0; j < this.rows[i].length; ++j) {
                tableAsText.append(this.rows[i][j].convertToText());
                if (j >= this.rows[i].length - 1) continue;
                tableAsText.append(',');
            }
            tableAsText.append('}');
            if (i >= this.rows.length - 1) continue;
            tableAsText.append(',');
        }
        tableAsText.append('}');
        return tableAsText.toString();
    }

    @Override
    public String getIDLType() {
        return TableParameterHelper.id();
    }

    @Override
    public void addRow(IParameterValue[] row) {
        IParameterValue[][] newRows = new IParameterValue[this.rows.length + 1][];
        for (int i = 0; i < this.rows.length; ++i) {
            newRows[i] = this.rows[i];
        }
        newRows[this.rows.length] = row;
        this.rows = newRows;
    }
}

