/*
 * Decompiled with CFR 0.152.
 */
package migration.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import migration.utils.Log;
import migration.utils.PrettyStatistics;
import migration.utils.Utils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class APICommunication {
    private Properties config;
    private PrettyStatistics counting;
    private JSONObject token;

    public APICommunication(PrettyStatistics counting, Properties config) {
        this.config = config;
        this.counting = counting;
        this.token = this.getToken();
    }

    private String getEndPoint(String endpoint_key) {
        return this.config.getProperty("api_base_url") + this.config.getProperty(endpoint_key);
    }

    private JSONObject getToken() {
        JSONObject token = null;
        try {
            URL url = new URL(this.getEndPoint("authentication_endpoint"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String input = "login=" + this.config.getProperty("authentication_user") + "&password=" + this.config.getProperty("authentication_password");
            OutputStream os = conn.getOutputStream();
            os.write(input.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                System.out.println("Failed : HTTP error code : " + conn.getResponseCode());
                System.out.println("Failed : ERROR_getToken_HTTP_error_code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getToken_HTTP_error_code_" + conn.getResponseCode(), null);
                conn.disconnect();
                System.exit(1);
            } else {
                String inputLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = br.readLine()) != null) {
                    response.append(inputLine);
                }
                token = new JSONObject(response.toString());
                conn.disconnect();
            }
        }
        catch (IOException | JSONException e) {
            System.out.println("Failed : ERROR_getToken_HTTP_error");
            e.printStackTrace();
            System.exit(1);
        }
        return token;
    }

    public JSONArray getProjects() {
        JSONArray projects = null;
        try {
            String inputLine;
            URL url = new URL(this.getEndPoint("projects_endpoint"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", this.token.getString("tokenType") + this.token.getString("accessToken"));
            if (conn.getResponseCode() != 200) {
                Log.print("URL: " + url);
                Log.print("Failed : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getProjects_HTTP_error_code_" + conn.getResponseCode(), null);
                conn.disconnect();
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            projects = new JSONArray(response.toString());
            conn.disconnect();
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        return projects;
    }

    public JSONArray getJobsFromProject(String projectId) {
        JSONArray jobJSONArray = null;
        try {
            String inputLine;
            URL url = new URL(this.getEndPoint("jobs_endpoint").replace("{{projectId}}", projectId));
            System.out.println(url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", this.token.getString("tokenType") + this.token.getString("accessToken"));
            if (conn.getResponseCode() != 200) {
                Log.print("Failed : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getJobsFromProject_HTTP_error_code_" + conn.getResponseCode(), null);
                conn.disconnect();
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            JSONObject jobJSONArrayObj = new JSONObject(response.toString());
            jobJSONArray = jobJSONArrayObj.getJSONArray("jobs");
            conn.disconnect();
            jobJSONArray = this.testEndTime(jobJSONArray);
        }
        catch (IOException | DateTimeParseException | JSONException e) {
            e.printStackTrace();
        }
        return jobJSONArray;
    }

    private JSONArray testEndTime(JSONArray jobJSONArray) {
        try {
            if (this.config.containsKey("use_job_walltime_to_calc_endtime") && Boolean.valueOf(this.config.getProperty("use_job_walltime_to_calc_endtime")).equals(true) && jobJSONArray != null) {
                for (int j = 0; j < jobJSONArray.length(); ++j) {
                    JSONObject jobJSONObj = null;
                    jobJSONObj = jobJSONArray.getJSONObject(j);
                    if (jobJSONObj.has("submissionTime") && jobJSONObj.has("wallclockTime")) {
                        String submissionTime = jobJSONObj.getString("submissionTime");
                        int wallclockTime = Integer.valueOf(jobJSONObj.getString("wallclockTime"));
                        jobJSONObj.put("endTime", Utils.addSecondToTimestamp(submissionTime, wallclockTime));
                        continue;
                    }
                    jobJSONObj.put("endTime", jobJSONObj.getString("submissionTime"));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jobJSONArray;
    }

    public List<JSONObject> getAlgorithmsFromJob(JSONObject jobJSONObj) throws JSONException {
        if (jobJSONObj.getString("jobType").toLowerCase().equals("flow")) {
            return this.getListOfAlgorithmFromFlow(this.token, jobJSONObj);
        }
        return this.getListOfAlgorithm(this.token, jobJSONObj);
    }

    private List<JSONObject> getListOfAlgorithmFromFlow(JSONObject token, JSONObject jobJSONObj) {
        ArrayList<JSONObject> output = new ArrayList<JSONObject>();
        try {
            String inputLine;
            String flowId = jobJSONObj.getString("jobId");
            URL url = new URL(this.getEndPoint("flowalgorithms_endpoint").replace("{{flowId}}", flowId));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", token.getString("tokenType") + token.getString("accessToken"));
            if (conn.getResponseCode() != 200) {
                Log.print(flowId + " GET PARAMS FAILED : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getAlgorithmsFromFlow_HTTP_error_code_" + conn.getResponseCode(), jobJSONObj);
                conn.disconnect();
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            if (response.length() > 0) {
                JSONObject algorithmsFromJob = new JSONObject(response.toString());
                Iterator keys = algorithmsFromJob.keys();
                while (keys.hasNext()) {
                    JSONArray paramsFromJob = new JSONArray();
                    String key = (String)keys.next();
                    JSONObject algorithmData = algorithmsFromJob.getJSONObject(key);
                    JSONObject paramsFromAlgorithm = this.getConfiguratorFromAlgorithm(algorithmData.getString("id"), algorithmData.getString("version"), jobJSONObj);
                    if (paramsFromAlgorithm == null) continue;
                    JSONObject params = algorithmData.getJSONObject("parameters");
                    Iterator paramsKeys = params.keys();
                    while (paramsKeys.hasNext()) {
                        String paramKey = (String)paramsKeys.next();
                        JSONObject configParam = this.getParamConfig(paramsFromAlgorithm, paramKey, jobJSONObj);
                        JSONObject param = new JSONObject();
                        param.put("param_id", paramKey);
                        param.put("param_type", params.getJSONObject(paramKey).getString("type"));
                        param.put("param_label", configParam.getString("label"));
                        param.put("param_value", params.getJSONObject(paramKey).getString("values"));
                        paramsFromJob.put(param);
                    }
                    algorithmData.put("params", paramsFromJob);
                    output.add(algorithmData);
                }
            }
            conn.disconnect();
        }
        catch (Exception ex) {
            Log.print(ex.toString());
        }
        return output;
    }

    private List<JSONObject> getListOfAlgorithm(JSONObject token, JSONObject jobJSONObj) {
        ArrayList<JSONObject> output = new ArrayList<JSONObject>();
        try {
            String inputLine;
            String algorithmId = jobJSONObj.getString("algorithmId");
            String algorithmName = jobJSONObj.getString("algorithmName");
            String algorithmVersion = jobJSONObj.getString("algorithmVersion");
            JSONObject paramsFromAlgorithm = this.getConfiguratorFromAlgorithm(algorithmId, algorithmVersion, jobJSONObj);
            if (paramsFromAlgorithm == null) {
                return null;
            }
            String jobId = jobJSONObj.getString("jobId");
            URL url = new URL(this.getEndPoint("parameters_endpoint").replace("{{jobId}}", jobId));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", token.getString("tokenType") + token.getString("accessToken"));
            if (conn.getResponseCode() != 200) {
                Log.print(jobId + " GET PARAMS FAILED : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getParamsFromJob_HTTP_error_code_" + conn.getResponseCode(), jobJSONObj);
                conn.disconnect();
                return null;
            }
            JSONObject algorithmData = new JSONObject();
            algorithmData.put("id", algorithmId);
            algorithmData.put("name", algorithmName);
            algorithmData.put("version", algorithmVersion);
            JSONArray paramsFromJob = new JSONArray();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            if (response.length() > 0) {
                JSONObject paramsFromJobDict = new JSONObject(response.toString());
                Iterator keys = paramsFromJobDict.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject configParam = this.getParamConfig(paramsFromAlgorithm, key, jobJSONObj);
                    if (configParam == null) continue;
                    JSONObject param = new JSONObject();
                    param.put("param_id", key);
                    param.put("param_type", paramsFromJobDict.getJSONObject(key).getString("type"));
                    param.put("param_label", configParam.getString("label"));
                    param.put("param_value", paramsFromJobDict.getJSONObject(key).getString("values"));
                    paramsFromJob.put(param);
                }
                algorithmData.put("params", paramsFromJob);
            }
            output.add(algorithmData);
            conn.disconnect();
        }
        catch (Exception e) {
            Log.print(e.toString());
        }
        return output;
    }

    private JSONObject getConfiguratorFromAlgorithm(String algorithmId, String algorithmVersion, JSONObject jobJSONObject) throws JSONException {
        JSONObject configFromAlgorithm = null;
        try {
            String urlString = this.getEndPoint("configuration_endpoint");
            urlString = urlString.replace("{{algorithmId}}", algorithmId);
            urlString = urlString.replace("{{algorithmVersion}}", algorithmVersion);
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", this.token.getString("tokenType") + this.token.getString("accessToken"));
            if (conn.getResponseCode() == 200) {
                String inputLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = br.readLine()) != null) {
                    response.append(inputLine);
                }
                if (response.length() > 0) {
                    configFromAlgorithm = new JSONObject(response.toString());
                }
            } else {
                Log.print(algorithmId + " GET getConfiguratorFromAlgorithm FAILED : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getConfiguratorFromAlgorithm_HTTP_error_code_" + conn.getResponseCode(), jobJSONObject);
            }
            conn.disconnect();
        }
        catch (IOException e) {
            Log.print(e.toString());
        }
        return configFromAlgorithm;
    }

    private JSONObject getParamConfig(JSONObject configuration, String paramKey, JSONObject jobJSONObject) throws JSONException {
        JSONArray configArray = configuration.getJSONArray("groups");
        for (int i = 0; i < configArray.length(); ++i) {
            JSONArray configGroup = configArray.getJSONObject(i).getJSONArray("parameters");
            for (int j = 0; j < configGroup.length(); ++j) {
                if (!configGroup.getJSONObject(j).getString("id").equals(paramKey)) continue;
                return configGroup.getJSONObject(j);
            }
        }
        this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_configuration_not_found", jobJSONObject);
        return null;
    }

    public JSONArray getNodes(JSONObject jobJSONObj) throws JSONException {
        JSONArray nodes = null;
        try {
            String inputLine;
            String jobId = jobJSONObj.getString("jobId");
            URL url = new URL(this.getEndPoint("flownodes_endpoint").replace("{{jobId}}", jobId));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", this.token.getString("tokenType") + this.token.getString("accessToken"));
            if (conn.getResponseCode() != 200) {
                Log.print(jobId + " GET NODES FAILED : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getFlowNodes_HTTP_error_code_" + conn.getResponseCode(), jobJSONObj);
                conn.disconnect();
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            nodes = new JSONArray(response.toString());
            conn.disconnect();
        }
        catch (Exception e) {
            Log.print(e.toString());
        }
        return nodes;
    }

    public JSONObject readFlowRaw(JSONObject jobJSONObj) throws JSONException {
        if (jobJSONObj.getString("jobType").toLowerCase().equals("flow")) {
            jobJSONObj.put("flowRaw", this.getFlowRaw(jobJSONObj));
        }
        return jobJSONObj;
    }

    private String getFlowRaw(JSONObject jobJSONObj) {
        String output = null;
        try {
            String inputLine;
            String jobId = jobJSONObj.getString("jobId");
            URL url = new URL(this.getEndPoint("flowraw_endpoint").replace("{{jobId}}", jobId));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Authorization", this.token.getString("tokenType") + this.token.getString("accessToken"));
            if (conn.getResponseCode() != 200) {
                Log.print(jobId + " GET PARAMS FAILED : HTTP error code : " + conn.getResponseCode());
                this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_getFlowRaw_HTTP_error_code_" + conn.getResponseCode(), jobJSONObj);
                conn.disconnect();
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            if (response.length() > 0) {
                output = response.toString();
            }
            conn.disconnect();
        }
        catch (Exception e) {
            Log.print(e.toString());
        }
        return output;
    }
}

