package migration.rest;

import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import migration.dao.JobDAO;
import migration.utils.Log;
import migration.utils.PrettyStatistics;

public class CSBASERestMigration {
  private APICommunication api;
  private PrettyStatistics counting;
  private PrettyStatistics projects;
  Properties config;

  public CSBASERestMigration(Properties config) {
    this.config = config;
    counting = new PrettyStatistics(new HashMap<>(), config);
    api = new APICommunication(counting, config);
    projects = new PrettyStatistics(new HashMap<>(), config);
  }

  public void execute() {
      JobDAO jobDao = new JobDAO(this.config);
      // PROJECTS
      JSONArray projectJSONArray = api.getProjects();
      if (projectJSONArray!= null) {
        counting.set("MIGRATED", 0);
        for (int i = 0; i < projectJSONArray.length(); i++) {
          counting.plusOne("TOTAL_PROJECTS");
          JSONObject jobJSONObj = null;
          try {
            JSONObject projectJSONObj = projectJSONArray.getJSONObject(i);
            Log.print("Project NAME: " + projectJSONObj.getString("name"));

            String projectId = new String(Base64.getDecoder().decode(projectJSONObj.getString("id")));
            projects.set(projectId+"_TOTAL_JOBS", 0);

            // JOBS
            JSONArray jobsJSONArray = api.getJobsFromProject(projectJSONObj.getString("id"));
            if (jobsJSONArray != null) {
              for (int j = 0; j < jobsJSONArray.length(); j++) {
                counting.plusOne("TOTAL_JOBS");
                projects.plusOne(projectId+"_TOTAL_JOBS");
                jobJSONObj = jobsJSONArray.getJSONObject(j);
                Log.print("--- JOB ID: " + jobJSONObj.getString("jobId"));

                // ALGORITHMS
                List<JSONObject> algorithms = api.getAlgorithmsFromJob(jobJSONObj);
                JSONArray nodesJSONArray = api.getNodes(jobJSONObj);
                jobJSONObj = api.readFlowRaw(jobJSONObj);
                if(algorithms!=null){
                  if (jobDao.insertJob(jobJSONObj, algorithms, nodesJSONArray)) {
                    counting.plusOne("MIGRATED");
                    projects.plusOne(projectId+"_TOTAL_MIGRATED_JOBS");
                  } else {
                    counting.plusOneError(config.getProperty("errorLogFile"),"ERROR_DB_RESTRICTION", jobJSONObj);
                    projects.plusOne(projectId+"_TOTAL_ERROR_DB_RESTRICTION_JOBS");
                  }
                }
              }
            }
          } catch (JSONException e) {
            counting.plusOneError(config.getProperty("errorLogFile"),"error_JSONException_function_execute_project", jobJSONObj);
            Log.print(e);
          }
        }
      }
    Log.print(counting);
    Log.print(projects);
    }
}
