package migration.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Log {

  private static String currentTime(){
    return new SimpleDateFormat("dd/MM/yyyy_HH:mm:ss").format(Calendar.getInstance().getTime());
  }

  public static void print(Object obj){
    String logMessage = currentTime()+":  "+ obj;
    System.out.println(logMessage);
    Log.writeLogFile("log.txt", logMessage);
  }

  private static String getERRORCSVFileValues(String[] attributes, String errorMessage, JSONObject jobInfo) {
    String values = "";
    String timeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
    for (String att: attributes){
      if (values.isEmpty()) {
        values += timeStamp+","+errorMessage + ",";
      } else {
        values += ",";
      }
      if(jobInfo != null && jobInfo.has(att)) {
        try {
          values += jobInfo.getString(att);
        }
        catch (JSONException e) {
          Log.print(e.toString());
        }
      }
    }
    return values;
  }


  public static void writeERRORCSVFile(String errorFileName, String errorMessage, String parameters, JSONObject jobJSONObject) {
    String eol = System.getProperty("line.separator");
    boolean existFile = new File(errorFileName).exists() ;
    try (Writer writer = new FileWriter(errorFileName, existFile)) {
      if (!existFile) {
        writer.append("CURRENT_TIMESTAMP,ERROR,");
        writer.append(parameters);
        writer.append(eol);
      }
      writer.append(Log.getERRORCSVFileValues(parameters.split(","), errorMessage, jobJSONObject));
      writer.append(eol);
    }
    catch (IOException ex) {
      ex.printStackTrace(System.err);
    }
  }

  public static void writeLogFile(String logFileName, String message) {
    String eol = System.getProperty("line.separator");
    boolean existFile = new File(logFileName).exists() ;
    try (Writer writer = new FileWriter(logFileName, existFile)) {
      writer.append(message);
      writer.append(eol);
    }
    catch (IOException ex) {
      ex.printStackTrace(System.err);
    }
  }


}
