/*
 * Decompiled with CFR 0.152.
 */
package migration.rest;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import migration.dao.JobDAO;
import migration.rest.APICommunication;
import migration.utils.Log;
import migration.utils.PrettyStatistics;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CSBASERestMigration {
    private APICommunication api;
    private PrettyStatistics counting;
    private PrettyStatistics projects;
    Properties config;

    public CSBASERestMigration(Properties config) {
        this.config = config;
        this.counting = new PrettyStatistics(new HashMap<String, Integer>(), config);
        this.api = new APICommunication(this.counting, config);
        this.projects = new PrettyStatistics(new HashMap<String, Integer>(), config);
    }

    public void execute() {
        JobDAO jobDao = new JobDAO(this.config);
        JSONArray projectJSONArray = this.api.getProjects();
        if (projectJSONArray != null) {
            this.counting.set("MIGRATED", 0);
            for (int i = 0; i < projectJSONArray.length(); ++i) {
                this.counting.plusOne("TOTAL_PROJECTS");
                JSONObject jobJSONObj = null;
                try {
                    JSONObject projectJSONObj = projectJSONArray.getJSONObject(i);
                    Log.print("Project NAME: " + projectJSONObj.getString("name"));
                    String projectId = new String(Base64.getDecoder().decode(projectJSONObj.getString("id")));
                    this.projects.set(projectId + "_TOTAL_JOBS", 0);
                    JSONArray jobsJSONArray = this.api.getJobsFromProject(projectJSONObj.getString("id"));
                    if (jobsJSONArray == null) continue;
                    for (int j = 0; j < jobsJSONArray.length(); ++j) {
                        this.counting.plusOne("TOTAL_JOBS");
                        this.projects.plusOne(projectId + "_TOTAL_JOBS");
                        jobJSONObj = jobsJSONArray.getJSONObject(j);
                        Log.print("--- JOB ID: " + jobJSONObj.getString("jobId"));
                        List<JSONObject> algorithms = this.api.getAlgorithmsFromJob(jobJSONObj);
                        JSONArray nodesJSONArray = this.api.getNodes(jobJSONObj);
                        jobJSONObj = this.api.readFlowRaw(jobJSONObj);
                        if (algorithms == null) continue;
                        if (jobDao.insertJob(jobJSONObj, algorithms, nodesJSONArray)) {
                            this.counting.plusOne("MIGRATED");
                            this.projects.plusOne(projectId + "_TOTAL_MIGRATED_JOBS");
                            continue;
                        }
                        this.counting.plusOneError(this.config.getProperty("errorLogFile"), "ERROR_DB_RESTRICTION", jobJSONObj);
                        this.projects.plusOne(projectId + "_TOTAL_ERROR_DB_RESTRICTION_JOBS");
                    }
                    continue;
                }
                catch (JSONException e) {
                    this.counting.plusOneError(this.config.getProperty("errorLogFile"), "error_JSONException_function_execute_project", jobJSONObj);
                    Log.print((Object)e);
                }
            }
        }
        Log.print(this.counting);
        Log.print(this.projects);
    }
}

