/*
 * Decompiled with CFR 0.152.
 */
package migration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Properties;
import migration.utils.Log;

public class Utils {
    public static Properties getConfigProperties(String propFileName) {
        Properties prop = new Properties();
        try {
            File propertiesFile = new File(propFileName);
            Log.print("Reading properties file " + propertiesFile.getAbsolutePath());
            FileInputStream inputStream = new FileInputStream(propertiesFile);
            if (inputStream == null) {
                throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
            }
            prop.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static Properties getConfigPropertiesFromResource(String propFileName) {
        Properties prop = new Properties();
        try {
            InputStream inputStream = Utils.class.getClassLoader().getResourceAsStream(propFileName);
            if (inputStream == null) {
                throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
            }
            prop.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static Timestamp parseDate(Object value, String timezone) {
        if (value == null) {
            return null;
        }
        try {
            LocalDateTime dateOutput = LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_DATE_TIME);
            if (timezone != null) {
                return Timestamp.valueOf(dateOutput.atOffset(ZoneOffset.of(timezone)).atZoneSameInstant(ZoneId.of("UTC")).toLocalDateTime());
            }
            return Timestamp.valueOf(dateOutput);
        }
        catch (DateTimeParseException e) {
            Log.print("Discarding invalid timestamp: " + value);
            e.printStackTrace();
            return null;
        }
    }

    public static String addSecondToTimestamp(String timestamp, int seconds) {
        try {
            LocalDateTime originalDate = LocalDateTime.parse(timestamp, DateTimeFormatter.ISO_DATE_TIME);
            LocalDateTime datePlusSeconds = originalDate.plusSeconds(seconds);
            return DateTimeFormatter.ISO_DATE_TIME.format(datePlusSeconds);
        }
        catch (DateTimeParseException e) {
            Log.print("Discarding invalid timestamp: " + timestamp);
            e.printStackTrace();
            return null;
        }
    }
}

