/*
 * Decompiled with CFR 0.152.
 */
package migration.rest;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import migration.dao.JobDAO;
import migration.rest.APICommunication;
import migration.utils.Log;
import migration.utils.PrettyStatistics;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CSBASERestMigration {
    Properties config;
    private APICommunication api;
    private PrettyStatistics counting;
    private PrettyStatistics projects;

    public CSBASERestMigration(Properties config) {
        this.config = config;
        this.counting = new PrettyStatistics(new HashMap<String, Integer>(), config);
        this.api = new APICommunication(this.counting, config);
        this.projects = new PrettyStatistics(new HashMap<String, Integer>(), config);
    }

    public void execute() {
        JobDAO jobDao = new JobDAO(this.config);
        List<String> projectList = this.getProjectList();
        if (!projectList.isEmpty()) {
            this.counting.set("MIGRATED", 0);
            for (int i = 0; i < projectList.size(); ++i) {
                this.counting.plusOne("TOTAL_PROJECTS");
                JSONObject jobJSONObj = null;
                try {
                    String projectId = projectList.get(i);
                    Log.print(String.format("Project ID: %s (%d of %d)", projectId, i + 1, projectList.size()));
                    this.projects.set(projectId + "_TOTAL_JOBS", 0);
                    String encodedProjectId = Base64.getEncoder().encodeToString(projectId.getBytes(StandardCharsets.UTF_8));
                    JSONArray jobsJSONArray = this.api.getJobsFromProject(encodedProjectId);
                    if (jobsJSONArray == null) continue;
                    for (int j = 0; j < jobsJSONArray.length(); ++j) {
                        this.counting.plusOne("TOTAL_JOBS");
                        this.projects.plusOne(projectId + "_TOTAL_JOBS");
                        jobJSONObj = jobsJSONArray.getJSONObject(j);
                        Log.print(String.format("--- JOB ID: %s (%d of %d for project %s)", jobJSONObj.getString("jobId"), j + 1, jobsJSONArray.length(), projectId));
                        if (jobDao.jobExists(jobJSONObj.getString("jobId"))) {
                            Log.print(String.format("--- JOB ID: %s already migrated. Skipping ", jobJSONObj.getString("jobId")));
                            this.counting.plusOneError("JOB_ALREADY_MIGRATED", jobJSONObj);
                            continue;
                        }
                        List<JSONObject> algorithms = this.api.getAlgorithmsFromJob(jobJSONObj);
                        JSONArray nodesJSONArray = this.api.getNodes(jobJSONObj);
                        jobJSONObj = this.api.readFlowRaw(jobJSONObj);
                        if (algorithms == null) continue;
                        if (jobDao.insertJob(jobJSONObj, algorithms, nodesJSONArray)) {
                            this.counting.plusOne("MIGRATED");
                            this.projects.plusOne(projectId + "_TOTAL_MIGRATED_JOBS");
                            continue;
                        }
                        this.counting.plusOneError("ERROR_DB_RESTRICTION", jobJSONObj);
                        this.projects.plusOne(projectId + "_TOTAL_ERROR_DB_RESTRICTION_JOBS");
                    }
                    continue;
                }
                catch (JSONException e) {
                    this.counting.plusOneError("error_JSONException_function_execute_project", jobJSONObj);
                    Log.print(e);
                }
            }
        }
        Log.print(this.counting);
        Log.print(this.projects);
    }

    private List<String> getProjectList() {
        List<String> projectList = this.getProjectListFromProperties();
        if (projectList.isEmpty()) {
            projectList = this.getProjectListFromServer();
        }
        return projectList;
    }

    private List<String> getProjectListFromProperties() {
        if (this.config.containsKey("projectList")) {
            return Arrays.stream(this.config.getProperty("projectList").split(",")).filter(Predicate.not(String::isBlank)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private List<String> getProjectListFromServer() {
        JSONArray projectJSONArray = this.api.getProjects();
        if (projectJSONArray.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> projectList = new ArrayList<String>();
        for (int i = 0; i < projectJSONArray.length(); ++i) {
            try {
                JSONObject projectJSONObj = projectJSONArray.getJSONObject(i);
                String projectId = new String(Base64.getDecoder().decode(projectJSONObj.getString("id")));
                Log.print("Project ID: " + projectId);
                projectList.add(projectId);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return projectList;
    }
}

