import java.io.File;
import java.util.Properties;

import migration.rest.CSBASERestMigration;
import migration.utils.Log;
import migration.utils.Utils;

public class Main {
  public static void main(String[] args) {
    String propertiesFilePath;
    if (args.length > 0) {
      propertiesFilePath = args[0];
    } else {
      propertiesFilePath = "system.properties";
    }
    File propertiesFile = new File(propertiesFilePath);
    if(propertiesFile.exists() && propertiesFile.canRead()) {
      Properties config = Utils.getConfigProperties(propertiesFilePath);
      CSBASERestMigration migration = new CSBASERestMigration(config);
      migration.execute();
    } else {
      Log.print("Please, enter a system.properties file parameter.");
    }
  }

}
