package migration.utils;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

import org.codehaus.jettison.json.JSONObject;

public class PrettyStatistics {
  private Map<String, Integer> map;
  Properties config;

  public PrettyStatistics(Map<String, Integer> map, Properties config) {
    this.config = config;
    this.map = map;
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    Map<String, Integer> reversedMap = new TreeMap<>(map);
    sb.append("\n");
    sb.append("\n");
    sb.append("======= STATISTICS =======");
    sb.append("\n");
    for (Map.Entry entry : reversedMap.entrySet()) {
      sb.append(entry.getKey());
      sb.append(" = ");
      sb.append(entry.getValue());
      sb.append("\n");
    }
    sb.append("\n");
    return sb.toString();
  }

  public void plusOne(String key){
    if(map.containsKey(key)) {
      map.put(key, map.get(key)+ 1);
    } else {
      map.put(key, 1);
    }
  }

  public void plusOneError(String errorKey, JSONObject jobJSONObject){
    this.plusOne(errorKey);
    Log.writeERRORCSVFile(errorKey, config.getProperty("propertiesErrorLogFile"), jobJSONObject);
  }

  public void set(String key, int value){
      map.put(key, value);
  }

}
