/*
 * Decompiled with CFR 0.152.
 */
package migration.utils;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import migration.utils.Log;
import org.codehaus.jettison.json.JSONObject;

public class PrettyStatistics {
    private Map<String, Integer> map;
    Properties config;

    public PrettyStatistics(Map<String, Integer> map, Properties config) {
        this.config = config;
        this.map = map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Integer> reversedMap = new TreeMap<String, Integer>(this.map);
        sb.append("\n");
        sb.append("\n");
        sb.append("======= STATISTICS =======");
        sb.append("\n");
        for (Map.Entry entry : reversedMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void plusOne(String key) {
        if (this.map.containsKey(key)) {
            this.map.put(key, this.map.get(key) + 1);
        } else {
            this.map.put(key, 1);
        }
    }

    public void plusOneError(String errorKey, JSONObject jobJSONObject) {
        this.plusOne(errorKey);
        Log.writeERRORCSVFile(errorKey, this.config.getProperty("propertiesErrorLogFile"), jobJSONObject);
    }

    public void set(String key, int value) {
        this.map.put(key, value);
    }
}

