/*
 * Decompiled with CFR 0.152.
 */
package migration.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Log {
    static String TIMESTAMP = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime());
    static String LOG_FILENAME = String.format("%s_log.log", TIMESTAMP);
    static String ERROR_FILENAME = String.format("%s_job_migration_error_log.csv", TIMESTAMP);

    private static String currentTime() {
        return new SimpleDateFormat("dd/MM/yyyy_HH:mm:ss").format(Calendar.getInstance().getTime());
    }

    public static void print(Object obj) {
        String logMessage = Log.currentTime() + ":  " + obj;
        System.out.println(logMessage);
        Log.writeLogFile(logMessage);
    }

    private static String getERRORCSVFileValues(String[] attributes, String errorMessage, JSONObject jobInfo) {
        Object values = "";
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        for (String att : attributes) {
            values = ((String)values).isEmpty() ? (String)values + timeStamp + "," + errorMessage + "," : (String)values + ",";
            if (jobInfo == null || !jobInfo.has(att)) continue;
            try {
                values = (String)values + jobInfo.getString(att);
            }
            catch (JSONException e) {
                Log.print(e.toString());
            }
        }
        return values;
    }

    public static void writeERRORCSVFile(String errorMessage, String parameters, JSONObject jobJSONObject) {
        String eol = System.getProperty("line.separator");
        boolean existFile = new File(ERROR_FILENAME).exists();
        try (FileWriter writer = new FileWriter(ERROR_FILENAME, existFile);){
            if (!existFile) {
                ((Writer)writer).append("CURRENT_TIMESTAMP,ERROR,");
                ((Writer)writer).append(parameters);
                ((Writer)writer).append(eol);
            }
            ((Writer)writer).append(Log.getERRORCSVFileValues(parameters.split(","), errorMessage, jobJSONObject));
            ((Writer)writer).append(eol);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void writeLogFile(String message) {
        String eol = System.getProperty("line.separator");
        boolean existFile = new File(LOG_FILENAME).exists();
        try (FileWriter writer = new FileWriter(LOG_FILENAME, existFile);){
            ((Writer)writer).append(message);
            ((Writer)writer).append(eol);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

