package migration.utils;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PrettyStatistics {
  Properties config;
  private Map<String, Integer> map;

  public PrettyStatistics(Map<String, Integer> map, Properties config) {
    this.config = config;
    this.map = map;
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    Map<String, Integer> reversedMap = new TreeMap<>(map);
    sb.append("\n");
    sb.append("\n");
    sb.append("======= STATISTICS =======");
    sb.append("\n");
    for (Map.Entry entry : reversedMap.entrySet()) {
      sb.append(entry.getKey());
      sb.append(" = ");
      sb.append(entry.getValue());
      sb.append("\n");
    }
    sb.append("\n");
    return sb.toString();
  }

  public void plusOne(String key) {
    if (map.containsKey(key)) {
      map.put(key, map.get(key) + 1);
    } else {
      map.put(key, 1);
    }
  }

  public void plusOneError(String errorKey, JSONObject jobJSONObject) {
    this.plusOne(errorKey);
    Log.writeERRORCSVFile(errorKey, config.getProperty("propertiesErrorLogFile"), jobJSONObject);
  }

  public void plusOneErrorWithJobIdOnly(String errorKey, String jobId) {
    this.plusOne(errorKey);
    JSONObject jobJSONObject = null;
    try {
      jobJSONObject = new JSONObject(String.format("{\"jobId\":\"%s\"}", jobId));
      Log.writeERRORCSVFile(errorKey, config.getProperty("propertiesErrorLogFile"), jobJSONObject);
    } catch (JSONException e) {
      e.printStackTrace();
    }
    Log.writeERRORCSVFile(errorKey, config.getProperty("propertiesErrorLogFile"), jobJSONObject);
  }

  public void set(String key, int value) {
    map.put(key, value);
  }
}
