/*
 * Decompiled with CFR 0.152.
 */
package migration.dao;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import migration.utils.Log;
import migration.utils.Utils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JobDAO {
    private Connection connection;
    private Properties sql;
    private Properties config;

    public JobDAO(Properties config) {
        this.config = config;
        this.sql = Utils.getConfigPropertiesFromResource("sql.properties");
    }

    public Connection getConn() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                Log.print("Getting a new DB CONNECTION!");
                Properties connConfig = new Properties();
                connConfig.put("user", this.config.getProperty("dbUser"));
                connConfig.put("password", this.config.getProperty("dbPassword"));
                this.connection = DriverManager.getConnection(this.config.getProperty("dbHost"), connConfig);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return this.connection;
    }

    private boolean insertJobAlgorithms(List<JSONObject> algorithms, JSONArray nodes, int jobId) {
        try {
            for (JSONObject algorithm : algorithms) {
                int jobAlgorithmId = this.getNextSequenceId("job_algorithms_seq");
                PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("insert_job_algorithms"));
                st.setInt(1, jobAlgorithmId);
                st.setString(2, algorithm.getString("id"));
                st.setString(3, algorithm.getString("name"));
                st.setString(4, algorithm.getString("version"));
                if (algorithm.has("flowNodeId")) {
                    int flowNodeId = algorithm.getInt("flowNodeId");
                    st.setInt(5, flowNodeId);
                    Integer flowNodeExitCode = this.getNodeExitCode(nodes, flowNodeId);
                    if (flowNodeExitCode != null) {
                        st.setInt(7, flowNodeExitCode);
                    } else {
                        st.setNull(7, 4);
                    }
                } else {
                    st.setInt(5, 0);
                    st.setNull(7, 4);
                }
                st.setInt(6, jobId);
                st.executeUpdate();
                st.close();
                if (!algorithm.has("params") || this.insertJobAlgorithmParameters(algorithm, jobAlgorithmId)) continue;
                return false;
            }
            return true;
        }
        catch (SQLException | JSONException e) {
            Log.print(e.toString());
            return false;
        }
    }

    private Integer getNodeExitCode(JSONArray nodes, Integer nodeId) {
        try {
            for (int i = 0; i < nodes.length(); ++i) {
                JSONObject node = nodes.getJSONObject(i);
                if (node.getInt("flow_node_id") != nodeId.intValue()) continue;
                if (node.has("flow_node_exit_code")) {
                    return node.getInt("flow_node_exit_code");
                }
                return null;
            }
        }
        catch (JSONException e) {
            Log.print(e.toString());
            return null;
        }
        return null;
    }

    private Integer getGuiltyNode(JSONArray nodes) {
        try {
            for (int i = 0; i < nodes.length(); ++i) {
                JSONObject node = nodes.getJSONObject(i);
                if (!node.has("flow_node_is_guilty") || !node.getBoolean("flow_node_is_guilty") || !node.has("flow_node_id")) continue;
                return node.getInt("flow_node_id");
            }
        }
        catch (JSONException e) {
            Log.print(e.toString());
            return null;
        }
        return null;
    }

    private boolean insertJobAlgorithmParameters(JSONObject algorithm, int jobAlgorithmId) {
        try {
            JSONArray algorithmParameters = algorithm.getJSONArray("params");
            for (int i = 0; i < algorithmParameters.length(); ++i) {
                JSONObject param = algorithmParameters.getJSONObject(i);
                int jobAParamAlgorithmId = this.getNextSequenceId("job_algo_params_seq");
                PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("insert_job_algo_params"));
                st.setInt(1, jobAParamAlgorithmId);
                st.setString(2, param.getString("param_label"));
                st.setString(3, param.getString("param_id"));
                st.setString(4, param.getString("param_type"));
                st.setInt(5, jobAlgorithmId);
                st.executeUpdate();
                st.close();
                if (this.insertJobAlgorithmParameterValues(param, jobAParamAlgorithmId)) continue;
                return false;
            }
        }
        catch (SQLException | JSONException e) {
            Log.print(e.toString());
        }
        return true;
    }

    private boolean insertJobAlgorithmParameterValues(JSONObject param, int jobAParamAlgorithmId) {
        try {
            PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("insert_job_param_values"));
            int jobAParamId = this.getNextSequenceId("job_param_values_seq");
            st.setInt(1, jobAParamAlgorithmId);
            st.setInt(2, jobAParamId);
            st.setString(3, param.getString("param_value"));
            st.executeUpdate();
            st.close();
            return true;
        }
        catch (SQLException | JSONException e) {
            Log.print(e.toString());
            return false;
        }
    }

    private boolean insertStatusHistoryFromJob(JSONObject jobData, int jobId) {
        try {
            JSONArray statusListJSON = jobData.getJSONArray("statusHistory");
            for (int i = 0; i < statusListJSON.length(); ++i) {
                try {
                    int statusId = this.getNextSequenceId("job_status_history_seq");
                    JSONObject status = statusListJSON.getJSONObject(i);
                    Timestamp statusTimestamp = null;
                    if (status.has("timestamp")) {
                        statusTimestamp = Utils.parseDate(status.getString("timestamp"), this.config.getProperty("timezoneAPICSBASE"));
                    } else if (status.getString("status").toLowerCase().equals("finished")) {
                        statusTimestamp = Utils.parseDate(jobData.getString("endTime"), this.config.getProperty("timezoneAPICSBASE"));
                    }
                    if (statusTimestamp == null) continue;
                    PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("insert_job_status_history"));
                    st.setInt(1, statusId);
                    st.setString(2, status.getString("status"));
                    st.setTimestamp(3, statusTimestamp);
                    st.setInt(4, jobId);
                    st.executeUpdate();
                    st.close();
                    this.getConn().commit();
                    continue;
                }
                catch (SQLException e) {
                    this.getConn().rollback();
                    Log.print(e.toString());
                }
            }
            return true;
        }
        catch (SQLException | JSONException e) {
            Log.print(e.toString());
            return false;
        }
    }

    private boolean insertJobRow(JSONObject jobData, int jobId, Integer guiltyNodeId) {
        try {
            PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("insert_job"));
            st.setInt(1, jobId);
            st.setString(2, jobData.getString("jobId"));
            st.setString(3, jobData.getString("sessionId"));
            st.setString(4, jobData.getString("jobOwner"));
            st.setTimestamp(5, Utils.parseDate(jobData.getString("submissionTime"), this.config.getProperty("timezoneAPICSBASE")));
            st.setString(6, jobData.getString("executionMachine"));
            if (jobData.has("endTime") && !jobData.getString("endTime").isEmpty()) {
                st.setTimestamp(7, Utils.parseDate(jobData.getString("endTime"), this.config.getProperty("timezoneAPICSBASE")));
            } else {
                st.setNull(7, 93);
            }
            st.setInt(8, Integer.parseInt(jobData.getString("numberOfAttempts")));
            if (jobData.has("description") && !jobData.getString("description").isEmpty()) {
                byte[] desc = jobData.getString("description").getBytes(Charset.defaultCharset());
                st.setString(9, new String(desc, StandardCharsets.UTF_8));
            } else {
                st.setNull(9, 12);
            }
            st.setInt(10, Integer.parseInt(jobData.getString("priority")));
            if (jobData.has("exitStatus")) {
                st.setString(11, jobData.getString("exitStatus"));
            } else {
                st.setNull(11, 12);
            }
            if (jobData.has("wallclockTime")) {
                st.setInt(12, Integer.parseInt(jobData.getString("wallclockTime")));
            } else {
                st.setNull(12, 4);
            }
            st.setTimestamp(13, Utils.parseDate(jobData.getString("lastModifiedTime"), this.config.getProperty("timezoneAPICSBASE")));
            st.setBoolean(14, jobData.getBoolean("automaticallyMachineSelection"));
            st.setBoolean(15, false);
            st.setString(16, jobData.getString("jobType"));
            st.setBoolean(17, false);
            st.setInt(18, 1);
            st.setInt(19, 1);
            st.setString(20, jobData.getString("groupId"));
            if (jobData.has("exitCode")) {
                st.setInt(21, jobData.getInt("exitCode"));
            } else {
                st.setNull(21, 4);
            }
            if (jobData.has("flowRaw")) {
                st.setBytes(22, jobData.getString("flowRaw").getBytes());
            } else {
                st.setNull(22, -2);
            }
            if (guiltyNodeId != null) {
                st.setInt(23, guiltyNodeId);
            } else {
                st.setNull(23, 4);
            }
            st.executeUpdate();
            st.close();
            return true;
        }
        catch (SQLException | JSONException e) {
            try {
                Log.print(e.toString());
                this.getConn().rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public boolean insertJob(JSONObject jobData, List<JSONObject> algorithms, JSONArray nodes) {
        try {
            int jobId = this.getNextSequenceId("jobs_seq");
            this.getConn().setAutoCommit(false);
            if (this.insertJobRow(jobData, jobId, this.getGuiltyNode(nodes)) && this.insertJobAlgorithms(algorithms, nodes, jobId)) {
                this.getConn().commit();
                this.insertStatusHistoryFromJob(jobData, jobId);
                return true;
            }
            this.getConn().rollback();
            return false;
        }
        catch (SQLException e) {
            try {
                Log.print(e.toString());
                this.getConn().rollback();
            }
            catch (SQLException ex) {
                Log.print(ex.toString());
            }
            return false;
        }
    }

    private int getNextSequenceId(String sequenceName) {
        int nextSequenceNumber = 0;
        try {
            PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("query_next_sequence_number"));
            st.setString(1, sequenceName);
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                nextSequenceNumber = rs.getInt(1);
            }
            rs.close();
            st.close();
            return nextSequenceNumber;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
            return nextSequenceNumber;
        }
    }

    public boolean jobExists(String jobId) {
        try {
            PreparedStatement st = this.getConn().prepareStatement(this.sql.getProperty("check_job_exist"));
            st.setString(1, jobId);
            ResultSet rs = st.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }
}

