package migration.utils;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Log {
  static String TIMESTAMP;
  static String LOG_FILENAME;
  static String ERROR_FILENAME;

  static {
    TIMESTAMP = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime());
    LOG_FILENAME = String.format("%s_log.log", TIMESTAMP);
    ERROR_FILENAME = String.format("%s_job_migration_error_log.csv", TIMESTAMP);
  }

  private static String currentTime(){
    return new SimpleDateFormat("dd/MM/yyyy_HH:mm:ss").format(Calendar.getInstance().getTime());
  }

  public static void print(Object obj){
    String logMessage = currentTime()+":  "+ obj;
    System.out.println(logMessage);
    Log.writeLogFile(logMessage);
  }

  private static String getERRORCSVFileValues(String[] attributes, String errorMessage, JSONObject jobInfo) {
    String values = "";
    String timeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
    for (String att: attributes){
      if (values.isEmpty()) {
        values += timeStamp+","+errorMessage + ",";
      } else {
        values += ",";
      }
      if(jobInfo != null && jobInfo.has(att)) {
        try {
          values += jobInfo.getString(att);
        }
        catch (JSONException e) {
          Log.print(e.toString());
        }
      }
    }
    return values;
  }


  public static void writeERRORCSVFile(String errorMessage, String parameters, JSONObject jobJSONObject) {
    String eol = System.getProperty("line.separator");
    boolean existFile = new File(ERROR_FILENAME).exists() ;
    try (Writer writer = new FileWriter(ERROR_FILENAME, existFile)) {
      if (!existFile) {
        writer.append("CURRENT_TIMESTAMP,ERROR,");
        writer.append(parameters);
        writer.append(eol);
      }
      writer.append(Log.getERRORCSVFileValues(parameters.split(","), errorMessage, jobJSONObject));
      writer.append(eol);
    }
    catch (IOException ex) {
      ex.printStackTrace(System.err);
    }
  }

  public static void writeLogFile(String message) {
    String eol = System.getProperty("line.separator");
    boolean existFile = new File(LOG_FILENAME).exists() ;
    try (Writer writer = new FileWriter(LOG_FILENAME, existFile)) {
      writer.append(message);
      writer.append(eol);
    }
    catch (IOException ex) {
      ex.printStackTrace(System.err);
    }
  }
}
