package br.pucrio.tecgraf.soma.job.domain.model;

import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * Job Entity
 */
@Entity
@Immutable
@Subselect("SELECT (((j.id || '#') || jsh.id) || '#') || jpv.job_algo_param_id as generated_view_id," +
"j.id, j.job_id, j.group_id, j.project_id, j.user_id, j.auto_machine_selected," +
"jsm.machine_name, j.number_of_processes,  j.number_of_processes_by_machine," +
"j.submission_time, j.description, j.priority, j.multiple_execution, j.job_type," +
"j.number_of_retries, j.execution_machine, j.end_time, j.exit_code," +
"j.guilty_node_id, j.exit_status, j.cpu_time, j.wall_clock_time,    " +
"j.ram_mem, j.flow_id, j.flow_version, j.flow_name,  " +
"j.flow_raw, j.last_modified_time, j.is_deleted," +
//JobStatusHistory fields
"jsh.id as job_statushistory_id, jsh.job_status, jsh.status_timestamp," +
//Algorithms fields
"ja.id as ja_id, ja.algo_id, ja.algo_version, ja.algo_name, " +
//Algorithm Parameter
"jap.param_id, jap.param_label, jap.param_type," +
//job-param-values
"jpv.job_algo_param_id, jpv.value " +
"FROM jobs j " +
"LEFT JOIN job_selected_machines jsm ON (j.id = jsm.job_id) " +
"JOIN job_status_history jsh ON(j.id = jsh.job_id) " +
"JOIN job_algorithms ja ON (j.id = ja.job_id) " +
"JOIN job_algo_params jap ON (jap.job_algo_id = ja.id) " +
"JOIN job_param_values jpv ON (jpv.job_algo_param_id = jap.id) " +
"ORDER BY j.id, job_statushistory_id, jpv.job_algo_param_id")
@Synchronize({"jobs","job_status_history"})
public class JobView {

  // Generated Identifier: jobId + jobStatusHistoryId + jobParameterValueId
  @Id
  @Column(name="generated_view_id", updatable = false, nullable = false)
  private String viewId;

  // Identifier (from table job)
  @Column(name="id", nullable = false)
  private Long id;

  // Execution system's job identifier (from table job)
  @Column(name="job_id", unique = true)
  private String jobId;

  // Group identifier from table job
  @Column(name="group_id", nullable=true)
  private String groupId = null;

  // Project associated with the job (from table job)
  @Column(name="project_id", nullable=false)
  private String projectId = null;

  // User that submitted the job (from table job)
  @Column(name="user_id", nullable=false)
  private String jobOwner = null;

  // Flag to indicate option for automatically machine selection (from table job)
  @Column(name="auto_machine_selected", nullable=false)
  private Boolean automaticallyMachineSelection = null;
  
  @Column(name="machine_name", nullable=true)
  private String selectedMachine = null;

  // The total number of processes. In the case of multiple execution, this number can be greater than one. (from table job)
  @Column(name="number_of_processes", nullable=false)
  private Integer numberOfProcesses = 1;

  // The number of processes by machine. In the case of multiple execution, this number can be greater than one."(from table job)
  @Column(name="number_of_processes_by_machine", nullable=false)
  private Integer numberOfProcessesByMachine = 1;

  // The jobStatusTimestamp of job submission (from table job)
  @Column(name="submission_time", nullable=false)
  private LocalDateTime submissionTime = null;

  // Description (from table job)
  @Column(name="description", nullable=true, length=500)
  private String description = null;

  // Priority (from table job)
  @Column(name="priority", nullable=false)
  private Integer priority = null;

  // If the job submission request a multiple execution (from table job)
  @Column(name="multiple_execution", nullable=false)
  private Boolean multipleExecution = false;

  // If the job executes a simple algorithm or a flow (from table job)
  @Column(name="job_type", nullable=false)
  @Enumerated(EnumType.STRING)
  private JobSpecificationType jobType = JobSpecificationType.ALGORITHM;

  // The number of times the job has already being re-schedule (from table job)
  @Column(name="number_of_retries", nullable=false)
  private Integer numberOfRetries = 0;

  // The machine where the job executed (from table job)
  @Column(name="execution_machine", nullable=true)
  private String executionMachine = null;

  // The jobStatusTimestamp when the job finished its execution (from table job)
  @Column(name="end_time", nullable=true)
  private LocalDateTime endTime = null;

  // The job exit code (from table job)
  @Column(name="exit_code", nullable=true)
  private Integer exitCode = null;

  // The id of the algorithm of the flow that caused the job finishs earlier than expected. (from table job)
  @Column(name="guilty_node_id", nullable=true)
  private String guiltyNodeId = null;

  // The status of the job after execution (from table job)
  @Enumerated(EnumType.STRING)
  @Column(name="exit_status", nullable=true)
  private ExitStatus exitStatus = null;

  // The amount of CPU time used for processing the job (from table job)
  @Column(name="cpu_time", nullable=true)
  private Double cpuTime = null;

  // The actual amount of time taken to run the job (from table job)
  @Column(name="wall_clock_time", nullable=true)
  private Integer wallclockTime = null;

  // The amount of memory used to run the job
  @Column(name="ram_mem", nullable=true)
  private Double ramMemory = null;
  
  @Column(name="flow_id", nullable=true)
  // If the job specification type is a installed flow, the identification of this flow (from table job)
  private String flowId = null;

  // If the job specification type is a installed flow, the version of this flow (from table job)
  @Column(name="flow_version", nullable=true)
  private String flowVersion;

  // If the job specification type is a installed flow, the name of this flow (from table job)
  @Column(name="flow_name", nullable=true)
  private String flowName;

  // If the job specification type is a installed flow, the configuration of this flow (from table job)
  @Column(name="flow_raw", nullable=true)
  @Lob
  private byte[] flowRaw;

  // The jobStatusTimestamp when the job was last modified (from table job)
  @Column(name="last_modified_time", nullable=true)
  private LocalDateTime lastModifiedTime = null;

  // Soft delete flag (from table job)
  @Column(name="is_deleted", nullable=false)
  private boolean isDeleted = false;

  // Id (from table job_status_history)
  @Column(name="job_statushistory_id")
  private long jobStatushistoryId;

  // The status (from table job_status_history)
  @Enumerated(EnumType.STRING)
  @Column(name="job_status", nullable=false)
  private StatusType jobStatus = null;

  // The jobStatusTimestamp when the status was notified (from table job_status_history)
  @Column(name="status_timestamp", nullable=false)
  private LocalDateTime jobStatusTimestamp = null;
  
  // Id (from table job_algorithms)
  @Column(name="ja_id")
  private Long jaId;

  // The algorithm identification (from table job_algorithms)
  @Column(name="algo_id", nullable=false)
  private String algorithmId;

  // The algorithm version (from table job_algorithms)
  @Column(name="algo_version", nullable=false)
  private String algorithmVersion;

  // The algorithm name (from table job_algorithms)
  @Column(name="algo_name", nullable=false)
  private String algorithmName;
  
  // The parameter identifier (from table job_algo_params)
  @Column(name = "param_id", nullable = false)
  private String parameterId;

  // Parameter label (from table job_algo_params)
  @Column(name = "param_label", nullable = false)
  private String paramLabel;

  // The type of the parameter (from table job_algo_params)
  @Column(name = "param_type", nullable = false)
  private String paramType;

  // Job algorithm parameter id for value
  @Column(name = "job_algo_param_id", nullable = false)
  private Long jobAlgoParamId; 
  
  // Job parameter value
  @Column(name = "value", nullable = false, length = 10000)
  private String paramValue;

  public String getViewId() {
    return viewId;
  }

  public Long getId() {
    return id;
  }

  public String getJobId() {
    return jobId;
  }

  public String getGroupId() {
    return groupId;
  }

  public String getProjectId() {
    return projectId;
  }

  public String getJobOwner() {
    return jobOwner;
  }

  public Boolean getAutomaticallyMachineSelection() {
    return automaticallyMachineSelection;
  }

  public String getSelectedMachine() {
    return selectedMachine;
  }

  public Integer getNumberOfProcesses() {
    return numberOfProcesses;
  }

  public Integer getNumberOfProcessesByMachine() {
    return numberOfProcessesByMachine;
  }

  public LocalDateTime getSubmissionTime() {
    return submissionTime;
  }

  public String getDescription() {
    return description;
  }

  public Integer getPriority() {
    return priority;
  }

  public Boolean getMultipleExecution() {
    return multipleExecution;
  }

  public JobSpecificationType getJobType() {
    return jobType;
  }

  public Integer getNumberOfRetries() {
    return numberOfRetries;
  }

  public String getExecutionMachine() {
    return executionMachine;
  }

  public LocalDateTime getEndTime() {
    return endTime;
  }

  public Integer getExitCode() {
    return exitCode;
  }

  public String getGuiltyNodeId() {
    return guiltyNodeId;
  }

  public ExitStatus getExitStatus() {
    return exitStatus;
  }

  public Double getCpuTime() {
    return cpuTime;
  }

  public Integer getWallclockTime() {
    return wallclockTime;
  }

  public Double getRamMemory() {
    return ramMemory;
  }

  public String getFlowId() {
    return flowId;
  }

  public String getFlowVersion() {
    return flowVersion;
  }

  public String getFlowName() {
    return flowName;
  }

  public byte[] getFlowRaw() {
    return flowRaw;
  }

  public LocalDateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  public boolean isDeleted() {
    return isDeleted;
  }

  public long getJobStatushistoryId() {
    return jobStatushistoryId;
  }

  public StatusType getJobStatus() {
    return jobStatus;
  }

  public LocalDateTime getJobStatusTimestamp() {
    return jobStatusTimestamp;
  }

  public Long getJaId() {
    return jaId;
  }

  public String getAlgorithmId() {
    return algorithmId;
  }

  public String getAlgorithmVersion() {
    return algorithmVersion;
  }

  public String getAlgorithmName() {
    return algorithmName;
  }

  public String getParameterId() {
    return parameterId;
  }

  public String getParamLabel() {
    return paramLabel;
  }

  public String getParamType() {
    return paramType;
  }

  public Long getJobAlgoParamId() {
    return jobAlgoParamId;
  }

  public String getParamValue() {
    return paramValue;
  }
  }
