/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithmParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="job_algorithms")
public class JobAlgorithm
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="job_algorithms_generator")
    @SequenceGenerator(name="job_algorithms_generator", sequenceName="public.job_algorithms_seq", allocationSize=1)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="algo_id", nullable=false)
    private String algorithmId;
    @Column(name="algo_version", nullable=false)
    private String algorithmVersion;
    @Column(name="algo_name", nullable=false)
    private String algorithmName;
    @Column(name="flow_node_id", nullable=true)
    private int flowNodeId;
    @ManyToOne
    @JoinColumn(name="job_id", nullable=false)
    private Job job;
    @OneToMany(mappedBy="jobAlgorithm", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<JobAlgorithmParameter> parameters = new ArrayList<JobAlgorithmParameter>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public int getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(int flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public List<JobAlgorithmParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(JobAlgorithmParameter parameter) {
        parameter.setJobAlgorithm(this);
        this.parameters.add(parameter);
    }
}

