package br.pucrio.tecgraf.soma.job.domain.model;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * The history of job's status change
 */
@Entity
@Table(name="job_status_history")
public class JobStatusHistory {

	// Identifier
	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "job_status_history_generator")
	@SequenceGenerator(name="job_status_history_generator", sequenceName = "public.job_status_history_seq", allocationSize=1)
	@Column(name = "id", updatable = false, nullable = false)
	private long id;

	// The status
	@Enumerated(EnumType.STRING)
	@Column(name="job_status", nullable=false)
	private StatusType status = null;

	// The timestamp when the status was notified
	@Column(name="status_timestamp", nullable=false)
	private LocalDateTime timestamp = null;

	@ManyToOne
	@JoinColumn(name="job_id", nullable=false)
	private Job job;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public StatusType getStatus() {
		return status;
	}

	public void setStatus(StatusType status) {
		this.status = status;
	}

	public LocalDateTime getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(LocalDateTime timestamp) {
		this.timestamp = timestamp;
	}

	public Job getJob() {
		return job;
	}

	public void setJob(Job job) {
		this.job = job;
	}
}
