package br.pucrio.tecgraf.soma.job.domain.model;

import java.time.LocalDateTime;

import javax.persistence.*;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "multiflow")
public class Multiflow {
    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "multiflow_generator")
    @SequenceGenerator(name = "multiflow_generator", sequenceName = "public.multiflow_seq", allocationSize = 1)
    @Column(name = "id", updatable = false, nullable = false)
    private long id;

    @Column(name = "name", nullable = false)
    private String name = null;

    @CreationTimestamp
    @Column(name = "creation_time", updatable = false, nullable = false)
    private LocalDateTime creationTime;

    @UpdateTimestamp
    @Column(name = "last_modified_time", nullable = false)
    private LocalDateTime lastModifiedTime;

    @Column(name = "is_deleted", nullable = false)
    private boolean isDeleted = false;

    @ManyToOne
    @JoinColumn(name = "flow_id", foreignKey = @ForeignKey(name = "multiflow_flow_fk"), nullable = false)
    private Flow flow = null;

    public Multiflow() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getLastModifiedTime() {
        return lastModifiedTime;
    }

    public void setLastModifiedTime(LocalDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(boolean name) {
        this.isDeleted = name;
    }

    public Flow getFlow() {
        return flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }
}
