package br.pucrio.tecgraf.soma.job.domain.model;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.*;

import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name = "replica_file")
public class ReplicaFile {
    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "replica_file_generator")
    @SequenceGenerator(name = "replica_file_generator", sequenceName = "public.replica_file_seq", allocationSize = 1)
    @Column(name = "id", updatable = false, nullable = false)
    private long id;

    @Column(name = "name", nullable = false)
    private String name = null;

    @Column(name = "path", nullable = false)
    private String path = null;

    @CreationTimestamp
    @Column(name = "creation_time", nullable = false, updatable = false)
    private LocalDateTime creationTime;

    @OneToMany(mappedBy = "replicaFile", fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval = true)
    private List<MultiflowReplicaFile> multiflowReplicaFiles = new ArrayList<>();

    public ReplicaFile() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public List<MultiflowReplicaFile> getMultiflowReplicaFiles() {
        return multiflowReplicaFiles;
    }

    public void setMultiflowReplicaFiles(List<MultiflowReplicaFile> multiflowReplicaFiles) {
        this.multiflowReplicaFiles = multiflowReplicaFiles;
    }

}
