package br.pucrio.tecgraf.soma.job.domain.model;

import java.time.LocalDateTime;

import javax.persistence.*;

import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name = "replica_job")
public class ReplicaJob {
	// Identifier
	@Id
	@Column(name = "job_string_id", updatable = false, nullable = false)
	private String jobStringId;

	@CreationTimestamp
	@Column(name = "submission_time", updatable = false, nullable = false)
	private LocalDateTime submissionTime;

	@ManyToOne
	@JoinColumn(name = "replica_id", foreignKey = @ForeignKey(name = "replica_job_replica_fk"), nullable = false)
	private Replica replica = null;

	public ReplicaJob() {
	}

	public String getJobStringId() {
		return this.jobStringId;
	}

	public void setJobStringId(String jobStringId) {
		this.jobStringId = jobStringId;
	}

	public LocalDateTime getSubmissionTime() {
		return submissionTime;
	}

	public void setSubmissionTime(LocalDateTime submissionTime) {
		this.submissionTime = submissionTime;
	}

	public Replica getReplica() {
		return replica;
	}

	public void setReplica(Replica replica) {
		this.replica = replica;
	}
}
