package br.pucrio.tecgraf.soma.job.domain.model;

import java.util.Objects;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

@Entity
@Table(name = "lost_events", indexes = { @Index(columnList = "event_id", name = "event_id_idx"),
    @Index(columnList = "kafka_partition_id, kafka_offset", name = "kafka_partition_offset_idx") })
public class LostEvent {

  @Id
  @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "lost_events_generator")
  @SequenceGenerator(name = "lost_events_generator", sequenceName = "public.lost_events_seq", allocationSize = 1)
  @Column(name = "id", updatable = false, nullable = false)
  private long id;

  @Column(name = "event_id")
  private String eventId;

  @Column(name = "kafka_partition_id")
  private int kafkaPartition;

  @Column(name = "kafka_offset")
  private long kafkaOffset;

  @Lob
  @Column(name = "raw_string", columnDefinition = "TEXT")
  private String rawString;

  public LostEvent(String eventId, int kafkaPartition, long kafkaOffset, String rawString) {
    this.eventId = eventId;
    this.kafkaPartition = kafkaPartition;
    this.kafkaOffset = kafkaOffset;
    this.rawString = rawString;
  }

  public long getId() {
    return id;
  }

  public void setId(long id) {
    this.id = id;
  }

  public String getEventId() {
    return eventId;
  }

  public void setEventId(String eventId) {
    this.eventId = eventId;
  }

  public int getKafkaPartition() {
    return kafkaPartition;
  }

  public void setKafkaPartition(int kafkaPartition) {
    this.kafkaPartition = kafkaPartition;
  }

  public long getKafkaOffset() {
    return kafkaOffset;
  }

  public void setKafkaOffset(long kafkaOffset) {
    this.kafkaOffset = kafkaOffset;
  }

  public String getRawString() {
    return rawString;
  }

  public void setRawString(String rawString) {
    this.rawString = rawString;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LostEvent lostEvent = (LostEvent) o;
    return kafkaPartition == lostEvent.kafkaPartition && kafkaOffset == lostEvent.kafkaOffset && eventId.equals(
      lostEvent.eventId) && rawString.equals(lostEvent.rawString);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventId, kafkaPartition, kafkaOffset, rawString);
  }
}
