package br.pucrio.tecgraf.soma.job.domain.model;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import jakarta.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Job Algorithm Entity
 */
@Entity
@Table(name="job_algorithms")
public class JobAlgorithm implements Serializable {

    public JobAlgorithm() {
    }

    public JobAlgorithm(String algorithmId, String algorithmName) {
        this.algorithmId = algorithmId;
        this.algorithmName = algorithmName;
    }

    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "job_algorithms_generator")
    @SequenceGenerator(name="job_algorithms_generator", sequenceName = "public.job_algorithms_seq", allocationSize=1)
    @Column(name = "id", updatable = false, nullable = false)
    private Long id;

    // The algorithm identification
    @Column(name="algo_id", nullable=false)
    private String algorithmId;

    // The algorithm version
    @Column(name="algo_version", nullable=false)
    private String algorithmVersion;

    // The algorithm name
    @Column(name="algo_name", nullable=false)
    private String algorithmName;

    // The algorithm node id in a flow
    @Column(name="flow_node_id", nullable=true)
    private Integer flowNodeId;

    // The exit code for the execution of the node in a flow
    @Column(name="flow_node_exit_code", nullable=true)
    private Integer flowNodeExitCode;

    // The progress for the execution of the node in a flow
    @Column(name="flow_node_progress", nullable=true)
    private String flowNodeProgress;

    @ManyToOne
    @JoinColumn(name="job_id", nullable=false)
    private Job job;

    // The list of parameters used
    @OneToMany(mappedBy="jobAlgorithm", fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval = true)
    @Fetch(value = FetchMode.SUBSELECT)
    private List<JobAlgorithmParameter> parameters = new ArrayList<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAlgorithmId() {
        return algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String getAlgorithmVersion() {
        return algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public Integer getFlowNodeId() {
        return flowNodeId;
    }

    public void setFlowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Job getJob() {
        return job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public List<JobAlgorithmParameter> getParameters() {
        return parameters;
    }

    public void addParameter(JobAlgorithmParameter parameter) {
        parameter.setJobAlgorithm(this);
        this.parameters.add(parameter);
    }

    public Integer getFlowNodeExitCode() {
        return flowNodeExitCode;
    }

    public void setFlowNodeExitCode(Integer flowNodeExitCode) {
        this.flowNodeExitCode = flowNodeExitCode;
    }

    public String getFlowNodeProgress() {
        return flowNodeProgress;
    }

    public void setFlowNodeProgress(String flowNodeProgress) {
        this.flowNodeProgress = flowNodeProgress;
    }
}
