package br.pucrio.tecgraf.soma.job.domain.model;

import java.time.LocalDateTime;

import jakarta.persistence.*;

import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name = "replica_job")
public class ReplicaJob {
	// Identifier
	@Id
	@Column(name = "job_string_id", updatable = false, nullable = false)
	private String jobStringId;

	@CreationTimestamp
	@Column(name = "submission_time", updatable = false, nullable = false)
	private LocalDateTime submissionTime;

	@ManyToOne
	@JoinColumn(name = "replica_id", foreignKey = @ForeignKey(name = "replica_job_replica_fk"), nullable = false, updatable = false)
	private Replica replica = null;

	// Evita perder um ReplicaJob por falta de preenchimento da versão.
	// Além disso, tuplas anteriores à existência da coluna versão terão inicialmente version = -1.
	@Column(name = "version", updatable = false, nullable = false, columnDefinition = "int4 DEFAULT -1")
	private Integer version = null;

	@Column(name = "replica_dependency_raw", nullable = true, columnDefinition = "VARCHAR" )
	private String replicaDependencyRaw = null;

	public ReplicaJob() {
	}

	public String getJobStringId() {
		return this.jobStringId;
	}

	public void setJobStringId(String jobStringId) {
		this.jobStringId = jobStringId;
	}

	public LocalDateTime getSubmissionTime() {
		return submissionTime;
	}

	public void setSubmissionTime(LocalDateTime submissionTime) {
		this.submissionTime = submissionTime;
	}

	public Replica getReplica() {
		return replica;
	}

	public void setReplica(Replica replica) {
		this.replica = replica;
	}

	public Integer getVersion() {
		return this.version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public String getReplicaDependencyRaw() {
		return replicaDependencyRaw;
	}

	public void setReplicaDependencyRaw(String replicaDependencyRaw) {
		this.replicaDependencyRaw = replicaDependencyRaw;
	}
}
