/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.builder.BuilderTools;
import com.github.tennaito.rsql.jpa.PredicateBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPathCache {
    private static final Logger LOG = Logger.getLogger(PredicateBuilder.class.getName());
    private final Map<String, Path> cache = new HashMap<String, Path>();
    private final Metamodel metaModel;
    private final BuilderTools misc;

    JpaPathCache(From root, Metamodel metaModel, BuilderTools misc) {
        this.cache.put("", (Path)root);
        this.metaModel = metaModel;
        this.misc = misc;
    }

    private static <T> boolean hasPropertyName(String property, ManagedType<T> classMetadata) {
        Set names = classMetadata.getAttributes();
        for (Attribute name : names) {
            if (!name.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    private static <T> Class<?> findPropertyType(Attribute attribMeta) {
        if (attribMeta.isCollection()) {
            return ((PluralAttribute)attribMeta).getBindableJavaType();
        }
        return attribMeta.getJavaType();
    }

    private Path getPropertyPath(From entityPath, ManagedType entityManaged, String propertyName) {
        if (!JpaPathCache.hasPropertyName(propertyName, entityManaged)) {
            throw new IllegalArgumentException("Unknown property: " + propertyName + " from entity " + entityManaged.getJavaType().getName());
        }
        Attribute attribMeta = entityManaged.getAttribute(propertyName);
        String entityTypeName = entityManaged.getJavaType().getName();
        if (attribMeta.isAssociation()) {
            LOG.log(Level.INFO, "Create a join between {0} and {1}.", new Object[]{entityTypeName, JpaPathCache.findPropertyType(attribMeta).getName()});
            return entityPath.join(propertyName);
        }
        if (attribMeta.isCollection()) {
            Class collectionType = attribMeta.getJavaType();
            LOG.log(Level.INFO, "Create a collection join between {0} and {1}.", new Object[]{entityTypeName, collectionType.getName()});
            if (List.class.isAssignableFrom(collectionType)) {
                return entityPath.joinList(propertyName);
            }
            if (Map.class.isAssignableFrom(collectionType)) {
                return entityPath.joinMap(propertyName);
            }
            if (Set.class.isAssignableFrom(collectionType)) {
                return entityPath.joinSet(propertyName);
            }
            return entityPath.joinCollection(propertyName);
        }
        LOG.log(Level.INFO, "Create property path for type {0} property {1}.", new Object[]{entityTypeName, propertyName});
        return entityPath.get(propertyName);
    }

    public Path getPath(String fullName) {
        Path path;
        String propertyName;
        String entityName;
        Path found = this.cache.get(fullName);
        if (found != null) {
            return found;
        }
        int splitIdx = fullName.lastIndexOf(46);
        if (splitIdx == -1) {
            entityName = "";
            propertyName = fullName;
        } else {
            entityName = fullName.substring(0, splitIdx);
            propertyName = fullName.substring(splitIdx + 1);
        }
        From entityPath = (From)this.getPath(entityName);
        Class entityType = entityPath.getJavaType();
        String propertyAlias = this.misc.getPropertiesMapper().translate(propertyName, entityType);
        if (!propertyName.equals(propertyAlias)) {
            path = this.getPath(entityName + "." + propertyAlias);
        } else {
            ManagedType entityManaged = this.metaModel.managedType(entityType);
            path = this.getPropertyPath(entityPath, entityManaged, propertyName);
        }
        this.cache.put(fullName, path);
        return path;
    }
}

