package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.domain.model.KafkaOffsetInfo;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.KafkaOffsetInfoByIdSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.text.MessageFormat;

@Service
public class KafkaOffsetInfoService {

	private final Logger logger = LoggerFactory.getLogger(KafkaOffsetInfoService.class);

	private Repository<KafkaOffsetInfo, JPASpecification<KafkaOffsetInfo>> kafkaOffsetInfoRepository;

	@Autowired
	public KafkaOffsetInfoService(Repository<KafkaOffsetInfo, JPASpecification<KafkaOffsetInfo>> kafkaOffsetInfoRepository) {
		this.kafkaOffsetInfoRepository = kafkaOffsetInfoRepository;
	}

	@Transactional(rollbackFor = IOException.class)
	public void updateOffsetInfo(int partitionId, long offset) throws IOException{
		try {
			KafkaOffsetInfo currOffset = kafkaOffsetInfoRepository.first(new KafkaOffsetInfoByIdSpecification(partitionId));
			if (currOffset != null) {
				logger.info("Updating Kafka offset: [partition={}, offset={}].", partitionId, offset);
				currOffset.setPartitionOffset(offset);
			} else {
				logger.info("Adding Kafka offset: [partition={}, offset={}].", partitionId, offset);
				kafkaOffsetInfoRepository.add(new KafkaOffsetInfo(partitionId, offset));
			}
    } catch (Exception ex) {
      throw new IOException(
          MessageFormat.format(
              "Error trying to update the Kafka offset for the partition {0}.", partitionId),
          ex);
    }
	}

}
