/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mustache.MustacheEnvironmentCollector;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.autoconfigure.mustache.MustacheResourceTemplateLoader;
import org.springframework.boot.autoconfigure.mustache.web.MustacheViewResolver;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={Mustache.class})
@EnableConfigurationProperties(value={MustacheProperties.class})
public class MustacheAutoConfiguration {
    private static final Log logger = LogFactory.getLog(MustacheAutoConfiguration.class);
    private final MustacheProperties mustache;
    private final Environment environment;
    private final ApplicationContext applicationContext;

    public MustacheAutoConfiguration(MustacheProperties mustache, Environment environment2, ApplicationContext applicationContext) {
        this.mustache = mustache;
        this.environment = environment2;
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void checkTemplateLocationExists() {
        TemplateLocation location;
        if (this.mustache.isCheckTemplateLocation() && !(location = new TemplateLocation(this.mustache.getPrefix())).exists(this.applicationContext)) {
            logger.warn("Cannot find template location: " + location + " (please add some templates, check your Mustache configuration, or set spring.mustache.check-template-location=false)");
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={Mustache.Compiler.class})
    public Mustache.Compiler mustacheCompiler(Mustache.TemplateLoader mustacheTemplateLoader) {
        return Mustache.compiler().withLoader(mustacheTemplateLoader).withCollector(this.collector());
    }

    private Mustache.Collector collector() {
        MustacheEnvironmentCollector collector = new MustacheEnvironmentCollector();
        collector.setEnvironment(this.environment);
        return collector;
    }

    @Bean
    @ConditionalOnMissingBean(value={Mustache.TemplateLoader.class})
    public MustacheResourceTemplateLoader mustacheTemplateLoader() {
        MustacheResourceTemplateLoader loader = new MustacheResourceTemplateLoader(this.mustache.getPrefix(), this.mustache.getSuffix());
        loader.setCharset(this.mustache.getCharsetName());
        return loader;
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class MustacheWebConfiguration {
        private final MustacheProperties mustache;

        protected MustacheWebConfiguration(MustacheProperties mustache) {
            this.mustache = mustache;
        }

        @Bean
        @ConditionalOnMissingBean(value={MustacheViewResolver.class})
        public MustacheViewResolver mustacheViewResolver(Mustache.Compiler mustacheCompiler) {
            MustacheViewResolver resolver = new MustacheViewResolver();
            this.mustache.applyToViewResolver((Object)resolver);
            resolver.setCharset(this.mustache.getCharsetName());
            resolver.setCompiler(mustacheCompiler);
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }
    }
}

