/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.cdi.CdiRepositoryConfiguration;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class CdiRepositoryBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdiRepositoryBean.class);
    private static final CdiRepositoryConfiguration DEFAULT_CONFIGURATION = DefaultCdiRepositoryConfiguration.INSTANCE;
    private final Set<Annotation> qualifiers;
    private final Class<T> repositoryType;
    private final CustomRepositoryImplementationDetector detector;
    private final BeanManager beanManager;
    private final String passivationId;
    private transient T repoInstance;

    public CdiRepositoryBean(Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager) {
        this(qualifiers, repositoryType, beanManager, null);
    }

    public CdiRepositoryBean(Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, CustomRepositoryImplementationDetector detector) {
        Assert.notNull(qualifiers, "Qualifiers must not be null!");
        Assert.notNull((Object)beanManager, "BeanManager must not be null!");
        Assert.notNull(repositoryType, "Repoitory type must not be null!");
        Assert.isTrue(repositoryType.isInterface(), "RepositoryType must be an interface!");
        this.qualifiers = qualifiers;
        this.repositoryType = repositoryType;
        this.beanManager = beanManager;
        this.detector = detector;
        this.passivationId = this.createPassivationId(qualifiers, repositoryType);
    }

    private final String createPassivationId(Set<Annotation> qualifiers, Class<?> repositoryType) {
        ArrayList<String> qualifierNames = new ArrayList<String>(qualifiers.size());
        for (Annotation qualifier : qualifiers) {
            qualifierNames.add(qualifier.annotationType().getName());
        }
        Collections.sort(qualifierNames);
        StringBuilder builder = new StringBuilder(StringUtils.collectionToDelimitedString(qualifierNames, ":"));
        builder.append(":").append(repositoryType.getName());
        return builder.toString();
    }

    public Set<Type> getTypes() {
        HashSet interfaces = new HashSet();
        interfaces.add(this.repositoryType);
        interfaces.addAll(Arrays.asList(this.repositoryType.getInterfaces()));
        return new HashSet<Type>(interfaces);
    }

    protected <S> S getDependencyInstance(Bean<S> bean2, Class<S> type) {
        CreationalContext creationalContext = this.beanManager.createCreationalContext(bean2);
        return (S)this.beanManager.getReference(bean2, type, creationalContext);
    }

    public final void initialize() {
        this.create(this.beanManager.createCreationalContext((Contextual)this));
    }

    public final T create(CreationalContext<T> creationalContext) {
        if (this.repoInstance != null) {
            LOGGER.debug("Returning eagerly created CDI repository instance for {}.", (Object)this.repositoryType.getName());
            return this.repoInstance;
        }
        LOGGER.debug("Creating CDI repository bean instance for {}.", (Object)this.repositoryType.getName());
        this.repoInstance = this.create(creationalContext, this.repositoryType);
        return this.repoInstance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Destroying bean instance %s for repository type '%s'.", instance.toString(), this.repositoryType.getName()));
        }
        creationalContext.release();
    }

    protected CdiRepositoryConfiguration lookupConfiguration(BeanManager beanManager, Set<Annotation> qualifiers) {
        Set beans2 = beanManager.getBeans(CdiRepositoryConfiguration.class, this.getQualifiersArray(qualifiers));
        if (beans2.isEmpty()) {
            return DEFAULT_CONFIGURATION;
        }
        Bean bean2 = (Bean)beans2.iterator().next();
        return (CdiRepositoryConfiguration)this.getDependencyInstance(bean2, bean2.getBeanClass());
    }

    private Bean<?> getCustomImplementationBean(Class<?> repositoryType, BeanManager beanManager, Set<Annotation> qualifiers) {
        if (this.detector == null) {
            return null;
        }
        CdiRepositoryConfiguration cdiRepositoryConfiguration = this.lookupConfiguration(beanManager, qualifiers);
        Class<?> customImplementationClass = this.getCustomImplementationClass(repositoryType, cdiRepositoryConfiguration);
        if (customImplementationClass == null) {
            return null;
        }
        Set beans2 = beanManager.getBeans(customImplementationClass, this.getQualifiersArray(qualifiers));
        return beans2.isEmpty() ? null : (Bean)beans2.iterator().next();
    }

    private Class<?> getCustomImplementationClass(Class<?> repositoryType, CdiRepositoryConfiguration cdiRepositoryConfiguration) {
        String className = this.getCustomImplementationClassName(repositoryType, cdiRepositoryConfiguration);
        AbstractBeanDefinition beanDefinition = this.detector.detectCustomImplementation(className, Collections.singleton(repositoryType.getPackage().getName()), Collections.<TypeFilter>emptySet());
        if (beanDefinition == null) {
            return null;
        }
        try {
            return Class.forName(beanDefinition.getBeanClassName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve class for '%s'", beanDefinition.getBeanClassName()), (Throwable)e);
        }
    }

    private String getCustomImplementationClassName(Class<?> repositoryType, CdiRepositoryConfiguration cdiRepositoryConfiguration) {
        String configuredPostfix = cdiRepositoryConfiguration.getRepositoryImplementationPostfix();
        Assert.hasText(configuredPostfix, "Configured repository postfix must not be null or empty!");
        return ClassUtils.getShortName(repositoryType) + configuredPostfix;
    }

    private Annotation[] getQualifiersArray(Set<Annotation> qualifiers) {
        return qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getName() {
        return this.repositoryType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        HashSet<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : this.repositoryType.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Stereotype.class)) continue;
            stereotypes.add(annotationType);
        }
        return stereotypes;
    }

    public Class<?> getBeanClass() {
        return this.repositoryType;
    }

    public boolean isAlternative() {
        return this.repositoryType.isAnnotationPresent(Alternative.class);
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getId() {
        return this.passivationId;
    }

    @Deprecated
    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        Bean<T> customImplementationBean = this.getCustomImplementationBean(repositoryType, this.beanManager, this.qualifiers);
        Object customImplementation = customImplementationBean == null ? null : this.beanManager.getReference(customImplementationBean, (Type)customImplementationBean.getBeanClass(), this.beanManager.createCreationalContext(customImplementationBean));
        return this.create(creationalContext, repositoryType, customImplementation);
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Object customImplementation) {
        throw new UnsupportedOperationException("You have to implement create(CreationalContext<T>, Class<T>, Object) in order to use custom repository implementations");
    }

    public String toString() {
        return String.format("CdiRepositoryBean: type='%s', qualifiers=%s", this.repositoryType.getName(), this.qualifiers.toString());
    }

    static enum DefaultCdiRepositoryConfiguration implements CdiRepositoryConfiguration
    {
        INSTANCE;


        @Override
        public String getRepositoryImplementationPostfix() {
            return "Impl";
        }
    }
}

