package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToLocalDateTimeConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.SpecificationTypeConverter;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class ScheduledJobMapper {
  private static final String TYPE_MAP_NAME = "JobScheduledEventToJob";
  private static ScheduledJobMapper instance;

  private final ModelMapper modelMapper;
  private final TypeMap<JobScheduledEvent, Job> typeMap;

  private ScheduledJobMapper() {
    modelMapper = new ModelMapper();
    modelMapper.getConfiguration().setAmbiguityIgnored(true);
    modelMapper.getConfiguration().setSkipNullEnabled(true);

    typeMap = modelMapper.createTypeMap(JobScheduledEvent.class, Job.class, TYPE_MAP_NAME);

    typeMap.addMappings(mapper -> mapper.skip(Job::setId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfRetries));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExecutionMachine));
    typeMap.addMappings(mapper -> mapper.skip(Job::setEndTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExitCode));
    typeMap.addMappings(mapper -> mapper.skip(Job::setGuiltyNodeId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExitStatus));
    typeMap.addMappings(mapper -> mapper.skip(Job::setCpuTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setWallclockTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setRamMemory));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowVersion));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowName));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowRaw));
    typeMap.addMappings(mapper -> mapper.skip(Job::addAlgorithm));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDeleted));

    typeMap.addMapping(JobScheduledEvent::getOwner, Job::setJobOwner);
    typeMap.addMapping(JobScheduledEvent::getJobId, Job::setJobId);
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToLocalDateTimeConverter())
                .map(JobScheduledEvent::getTimestamp, Job::setLastModifiedTime));
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToLocalDateTimeConverter())
                .map(JobScheduledEvent::getSubmissionTime, Job::setSubmissionTime));
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new SpecificationTypeConverter())
                .map(JobScheduledEvent::getSpecificationType, Job::setJobType));

    modelMapper.validate();
  }

  public static ScheduledJobMapper getInstance() {
    if (instance == null) {
      instance = new ScheduledJobMapper();
    }
    return instance;
  }

  public void map(JobScheduledEvent event, Job job) {
    modelMapper.map(event, job, TYPE_MAP_NAME);
  }
}
