/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TransactionAwarePersistenceManagerFactoryProxy
implements FactoryBean<PersistenceManagerFactory> {
    private PersistenceManagerFactory target;
    private boolean allowCreate = true;
    private PersistenceManagerFactory proxy;

    public void setTargetPersistenceManagerFactory(PersistenceManagerFactory target) {
        Assert.notNull((Object)target, "Target PersistenceManagerFactory must not be null");
        this.target = target;
        Class<?>[] ifcs = ClassUtils.getAllInterfacesForClass(target.getClass(), target.getClass().getClassLoader());
        this.proxy = (PersistenceManagerFactory)Proxy.newProxyInstance(target.getClass().getClassLoader(), ifcs, (InvocationHandler)new PersistenceManagerFactoryInvocationHandler());
    }

    public PersistenceManagerFactory getTargetPersistenceManagerFactory() {
        return this.target;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    protected boolean isAllowCreate() {
        return this.allowCreate;
    }

    @Override
    public PersistenceManagerFactory getObject() {
        return this.proxy;
    }

    @Override
    public Class<? extends PersistenceManagerFactory> getObjectType() {
        return PersistenceManagerFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    private static class PersistenceManagerInvocationHandler
    implements InvocationHandler {
        private final PersistenceManager target;
        private final PersistenceManagerFactory persistenceManagerFactory;

        public PersistenceManagerInvocationHandler(PersistenceManager target, PersistenceManagerFactory pmf) {
            this.target = target;
            this.persistenceManagerFactory = pmf;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                PersistenceManagerFactoryUtils.doReleasePersistenceManager(this.target, this.persistenceManagerFactory);
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private class PersistenceManagerFactoryInvocationHandler
    implements InvocationHandler {
        private PersistenceManagerFactoryInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("getPersistenceManager")) {
                PersistenceManagerFactory target = TransactionAwarePersistenceManagerFactoryProxy.this.getTargetPersistenceManagerFactory();
                PersistenceManager pm = PersistenceManagerFactoryUtils.doGetPersistenceManager(target, TransactionAwarePersistenceManagerFactoryProxy.this.isAllowCreate());
                Class<?>[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), pm.getClass().getClassLoader());
                return Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new PersistenceManagerInvocationHandler(pm, target));
            }
            try {
                return method.invoke((Object)TransactionAwarePersistenceManagerFactoryProxy.this.getTargetPersistenceManagerFactory(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

