/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import org.springframework.util.Assert;

public final class Range<T extends Comparable<T>> {
    private final T lowerBound;
    private final T upperBound;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;

    public Range(T lowerBound, T upperBound) {
        this(lowerBound, upperBound, true, true);
    }

    public Range(T lowerBound, T upperBound, boolean lowerInclusive, boolean upperInclusive) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
    }

    public boolean contains(T value) {
        boolean greaterThanLowerBound;
        Assert.notNull(value, "Reference value must not be null!");
        boolean bl = this.lowerBound == null ? true : (this.lowerInclusive ? this.lowerBound.compareTo(value) <= 0 : (greaterThanLowerBound = this.lowerBound.compareTo(value) < 0));
        boolean lessThanUpperBound = this.upperBound == null ? true : (this.upperInclusive ? this.upperBound.compareTo(value) >= 0 : this.upperBound.compareTo(value) > 0);
        return greaterThanLowerBound && lessThanUpperBound;
    }

    public T getLowerBound() {
        return this.lowerBound;
    }

    public T getUpperBound() {
        return this.upperBound;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public boolean isUpperInclusive() {
        return this.upperInclusive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        T this$lowerBound = this.getLowerBound();
        T other$lowerBound = other.getLowerBound();
        if (this$lowerBound == null ? other$lowerBound != null : !this$lowerBound.equals(other$lowerBound)) {
            return false;
        }
        T this$upperBound = this.getUpperBound();
        T other$upperBound = other.getUpperBound();
        if (this$upperBound == null ? other$upperBound != null : !this$upperBound.equals(other$upperBound)) {
            return false;
        }
        if (this.isLowerInclusive() != other.isLowerInclusive()) {
            return false;
        }
        return this.isUpperInclusive() == other.isUpperInclusive();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $lowerBound = this.getLowerBound();
        result = result * 59 + ($lowerBound == null ? 43 : $lowerBound.hashCode());
        T $upperBound = this.getUpperBound();
        result = result * 59 + ($upperBound == null ? 43 : $upperBound.hashCode());
        result = result * 59 + (this.isLowerInclusive() ? 79 : 97);
        result = result * 59 + (this.isUpperInclusive() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Range(lowerBound=" + this.getLowerBound() + ", upperBound=" + this.getUpperBound() + ", lowerInclusive=" + this.isLowerInclusive() + ", upperInclusive=" + this.isUpperInclusive() + ")";
    }
}

