/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnBootstrapHostsCondition
extends SpringBootCondition {
    OnBootstrapHostsCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment2 = context.getEnvironment();
        PropertyResolver resolver = new PropertyResolver(((ConfigurableEnvironment)environment2).getPropertySources(), "spring.couchbase");
        Map.Entry<String, Object> entry = resolver.resolveProperty("bootstrap-hosts");
        if (entry != null) {
            return ConditionOutcome.match(ConditionMessage.forCondition(OnBootstrapHostsCondition.class.getName(), new Object[0]).found("property").items("spring.couchbase.bootstrap-hosts"));
        }
        return ConditionOutcome.noMatch(ConditionMessage.forCondition(OnBootstrapHostsCondition.class.getName(), new Object[0]).didNotFind("property").items("spring.couchbase.bootstrap-hosts"));
    }

    private static class PropertyResolver {
        private final String prefix;
        private final Map<String, Object> content;

        PropertyResolver(PropertySources propertySources, String prefix) {
            this.prefix = prefix;
            this.content = new HashMap<String, Object>();
            RelaxedDataBinder binder = new RelaxedDataBinder(this.content, this.prefix);
            binder.bind(new PropertySourcesPropertyValues(propertySources));
        }

        Map.Entry<String, Object> resolveProperty(String name) {
            RelaxedNames prefixes = new RelaxedNames(this.prefix);
            RelaxedNames keys = new RelaxedNames(name);
            for (String prefix : prefixes) {
                for (String relaxedKey : keys) {
                    String key = prefix + relaxedKey;
                    if (!this.content.containsKey(relaxedKey)) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(key, this.content.get(relaxedKey));
                }
            }
            return null;
        }
    }
}

