/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToLocalDateTimeConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.SpecificationTypeConverter;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class ScheduledJobMapper {
    private static final String TYPE_MAP_NAME = "JobScheduledEventToJob";
    private static ScheduledJobMapper instance;
    private final ModelMapper modelMapper = new ModelMapper();
    private final TypeMap<JobScheduledEvent, Job> typeMap;

    private ScheduledJobMapper() {
        this.modelMapper.getConfiguration().setAmbiguityIgnored(true);
        this.modelMapper.getConfiguration().setSkipNullEnabled(true);
        this.typeMap = this.modelMapper.createTypeMap(JobScheduledEvent.class, Job.class, TYPE_MAP_NAME);
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfRetries));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setExecutionMachine));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setEndTime));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setExitCode));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setGuiltyNodeId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setExitStatus));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setCpuTime));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setWallclockTime));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setRamMemory));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowVersion));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowName));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowRaw));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::addAlgorithm));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setDeleted));
        this.typeMap.addMapping(JobScheduledEvent::getOwner, Job::setJobOwner);
        this.typeMap.addMapping(JobScheduledEvent::getJobId, Job::setJobId);
        this.typeMap.addMapping(JobScheduledEvent::getProjectId, Job::setProjectId);
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new LongToLocalDateTimeConverter()).map(JobScheduledEvent::getTimestamp, Job::setLastModifiedTime));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new LongToLocalDateTimeConverter()).map(JobScheduledEvent::getSubmissionTime, Job::setSubmissionTime));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new SpecificationTypeConverter()).map(JobScheduledEvent::getSpecificationType, Job::setJobType));
        this.modelMapper.validate();
    }

    public static ScheduledJobMapper getInstance() {
        if (instance == null) {
            instance = new ScheduledJobMapper();
        }
        return instance;
    }

    public void map(JobScheduledEvent event, Job job) {
        this.modelMapper.map((Object)event, (Object)job, TYPE_MAP_NAME);
    }
}

