/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ConnectionBean;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.SaslServerCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerCnxnFactory {
    public static final String ZOOKEEPER_SERVER_CNXN_FACTORY = "zookeeper.serverCnxnFactory";
    private static final Logger LOG = LoggerFactory.getLogger(ServerCnxnFactory.class);
    protected final ConcurrentMap<Long, ServerCnxn> sessionMap = new ConcurrentHashMap<Long, ServerCnxn>();
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    protected SaslServerCallbackHandler saslServerCallbackHandler;
    public Login login;
    protected ZooKeeperServer zkServer;
    private final Map<ServerCnxn, ConnectionBean> connectionBeans = new ConcurrentHashMap<ServerCnxn, ConnectionBean>();
    protected final HashSet<ServerCnxn> cnxns = new HashSet();

    public abstract int getLocalPort();

    public abstract Iterable<ServerCnxn> getConnections();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumAliveConnections() {
        HashSet<ServerCnxn> hashSet = this.cnxns;
        synchronized (hashSet) {
            return this.cnxns.size();
        }
    }

    ZooKeeperServer getZooKeeperServer() {
        return this.zkServer;
    }

    public abstract void closeSession(long var1);

    public abstract void configure(InetSocketAddress var1, int var2) throws IOException;

    public abstract int getMaxClientCnxnsPerHost();

    public abstract void setMaxClientCnxnsPerHost(int var1);

    public abstract void startup(ZooKeeperServer var1) throws IOException, InterruptedException;

    public abstract void join() throws InterruptedException;

    public abstract void shutdown();

    public abstract void start();

    public final void setZooKeeperServer(ZooKeeperServer zk) {
        this.zkServer = zk;
        if (zk != null) {
            zk.setServerCnxnFactory(this);
        }
    }

    public abstract void closeAll();

    public static ServerCnxnFactory createFactory() throws IOException {
        String serverCnxnFactoryName = System.getProperty(ZOOKEEPER_SERVER_CNXN_FACTORY);
        if (serverCnxnFactoryName == null) {
            serverCnxnFactoryName = NIOServerCnxnFactory.class.getName();
        }
        try {
            ServerCnxnFactory serverCnxnFactory = (ServerCnxnFactory)Class.forName(serverCnxnFactoryName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOG.info("Using {} as server connection factory", (Object)serverCnxnFactoryName);
            return serverCnxnFactory;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Couldn't instantiate " + serverCnxnFactoryName);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static ServerCnxnFactory createFactory(int clientPort, int maxClientCnxns) throws IOException {
        return ServerCnxnFactory.createFactory(new InetSocketAddress(clientPort), maxClientCnxns);
    }

    public static ServerCnxnFactory createFactory(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        ServerCnxnFactory factory = ServerCnxnFactory.createFactory();
        factory.configure(addr, maxClientCnxns);
        return factory;
    }

    public abstract InetSocketAddress getLocalAddress();

    public void unregisterConnection(ServerCnxn serverCnxn) {
        ConnectionBean jmxConnectionBean = this.connectionBeans.remove(serverCnxn);
        if (jmxConnectionBean != null) {
            MBeanRegistry.getInstance().unregister(jmxConnectionBean);
        }
    }

    public void registerConnection(ServerCnxn serverCnxn) {
        if (this.zkServer != null) {
            ConnectionBean jmxConnectionBean = new ConnectionBean(serverCnxn, this.zkServer);
            try {
                MBeanRegistry.getInstance().register(jmxConnectionBean, this.zkServer.jmxServerBean);
                this.connectionBeans.put(serverCnxn, jmxConnectionBean);
            }
            catch (JMException e) {
                LOG.warn("Could not register connection", e);
            }
        }
    }

    public void addSession(long sessionId, ServerCnxn cnxn) {
        this.sessionMap.put(sessionId, cnxn);
    }

    protected void configureSaslLogin() throws IOException {
        String serverSection = System.getProperty("zookeeper.sasl.serverconfig", "Server");
        AppConfigurationEntry[] entries = null;
        SecurityException securityException = null;
        try {
            entries = Configuration.getConfiguration().getAppConfigurationEntry(serverSection);
        }
        catch (SecurityException e) {
            securityException = e;
        }
        if (entries == null) {
            String jaasFile = System.getProperty("java.security.auth.login.config");
            String loginContextName = System.getProperty("zookeeper.sasl.serverconfig");
            if (securityException != null && (loginContextName != null || jaasFile != null)) {
                String errorMessage = "No JAAS configuration section named '" + serverSection + "' was found";
                if (jaasFile != null) {
                    errorMessage = errorMessage + "in '" + jaasFile + "'.";
                }
                if (loginContextName != null) {
                    errorMessage = errorMessage + " But zookeeper.sasl.serverconfig was set.";
                }
                LOG.error(errorMessage);
                throw new IOException(errorMessage);
            }
            return;
        }
        try {
            this.saslServerCallbackHandler = new SaslServerCallbackHandler(Configuration.getConfiguration());
            this.login = new Login(serverSection, this.saslServerCallbackHandler);
            this.login.startThreadIfNeeded();
        }
        catch (LoginException e) {
            throw new IOException("Could not configure server because SASL configuration did not allow the  ZooKeeper server to authenticate itself properly: " + e);
        }
    }

    public static interface PacketProcessor {
        public void processPacket(ByteBuffer var1, ServerCnxn var2);
    }
}

