/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;

public abstract class LogFormatUtils {
    public static String formatValue(@Nullable Object value, boolean limitLength) {
        String str;
        if (value == null) {
            return "";
        }
        if (value instanceof CharSequence) {
            str = "\"" + value + "\"";
        } else {
            try {
                str = value.toString();
            }
            catch (Throwable ex) {
                str = ex.toString();
            }
        }
        return limitLength && str.length() > 100 ? str.substring(0, 100) + " (truncated)..." : str;
    }

    public static void traceDebug(Log logger2, Function<Boolean, String> messageFactory) {
        if (logger2.isDebugEnabled()) {
            String logMessage = messageFactory.apply(logger2.isTraceEnabled());
            if (logger2.isTraceEnabled()) {
                logger2.trace(logMessage);
            } else {
                logger2.debug(logMessage);
            }
        }
    }
}

