/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.support.AsyncRequestInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenEntityManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME = "entityManagerFactory";
    private String entityManagerFactoryBeanName;
    private String persistenceUnitName;
    private volatile EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactoryBeanName(String entityManagerFactoryBeanName) {
        this.entityManagerFactoryBeanName = entityManagerFactoryBeanName;
    }

    protected String getEntityManagerFactoryBeanName() {
        return this.entityManagerFactoryBeanName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    protected String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        EntityManagerFactory emf = this.lookupEntityManagerFactory(request);
        boolean participate = false;
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        String key = this.getAlreadyFilteredAttributeName();
        if (TransactionSynchronizationManager.hasResource(emf)) {
            participate = true;
        } else {
            boolean isFirstRequest;
            boolean bl = isFirstRequest = !this.isAsyncDispatch(request);
            if (isFirstRequest || !this.applyEntityManagerBindingInterceptor(asyncManager, key)) {
                this.logger.debug("Opening JPA EntityManager in OpenEntityManagerInViewFilter");
                try {
                    EntityManager em = this.createEntityManager(emf);
                    EntityManagerHolder emHolder = new EntityManagerHolder(em);
                    TransactionSynchronizationManager.bindResource(emf, emHolder);
                    AsyncRequestInterceptor interceptor = new AsyncRequestInterceptor(emf, emHolder);
                    asyncManager.registerCallableInterceptor((Object)key, (CallableProcessingInterceptor)interceptor);
                    asyncManager.registerDeferredResultInterceptor((Object)key, (DeferredResultProcessingInterceptor)interceptor);
                }
                catch (PersistenceException ex) {
                    throw new DataAccessResourceFailureException("Could not create JPA EntityManager", ex);
                }
            }
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(emf);
                if (!this.isAsyncStarted(request)) {
                    this.logger.debug("Closing JPA EntityManager in OpenEntityManagerInViewFilter");
                    EntityManagerFactoryUtils.closeEntityManager(emHolder.getEntityManager());
                }
            }
        }
    }

    protected EntityManagerFactory lookupEntityManagerFactory(HttpServletRequest request) {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.lookupEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    protected EntityManagerFactory lookupEntityManagerFactory() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String emfBeanName = this.getEntityManagerFactoryBeanName();
        String puName = this.getPersistenceUnitName();
        if (StringUtils.hasLength(emfBeanName)) {
            return (EntityManagerFactory)wac.getBean(emfBeanName, EntityManagerFactory.class);
        }
        if (!StringUtils.hasLength(puName) && wac.containsBean(DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME)) {
            return (EntityManagerFactory)wac.getBean(DEFAULT_ENTITY_MANAGER_FACTORY_BEAN_NAME, EntityManagerFactory.class);
        }
        return EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)wac, puName);
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf) {
        return emf.createEntityManager();
    }

    private boolean applyEntityManagerBindingInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((AsyncRequestInterceptor)asyncManager.getCallableInterceptor((Object)key)).bindSession();
        return true;
    }
}

