package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.*;
import br.pucrio.tecgraf.soma.job.application.service.KafkaOffsetInfoService;
import br.pucrio.tecgraf.soma.job.application.service.job.JobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;

import static br.pucrio.tecgraf.soma.job.Constants.JOB_SCHEDULED_EVENT;

@Service
public class JobHistoryEventService {

	private final Logger logger = LoggerFactory.getLogger(JobHistoryEventService.class);

	private JobService jobService;
	private KafkaOffsetInfoService kafkaOffsetInfoService;

	@Autowired
	public JobHistoryEventService(JobService jobService, KafkaOffsetInfoService kafkaOffsetInfoService) {
		this.jobService = jobService;
		this.kafkaOffsetInfoService = kafkaOffsetInfoService;
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public void process(JobHistoryEvent historyEvent, int partitionId, long lastOffset) throws IOException {
		switch (historyEvent.getEventName()) {
		case JOB_SCHEDULED_EVENT:
			jobService.scheduleJob((JobScheduledEvent) historyEvent.getEvent());
			break;
		case Constants.JOB_RESCHEDULED_EVENT:
			jobService.rescheduleJob((JobRescheduledEvent) historyEvent.getEvent());
			break;
		case Constants.JOB_STAGEIN_EVENT:
			jobService.stageJobIn((JobStageInEvent) historyEvent.getEvent());
			break;
		case Constants.JOB_STAGEOUT_EVENT:
			jobService.stageJobOut((JobStageOutEvent) historyEvent.getEvent());
			break;
		case Constants.JOB_EXECUTING_EVENT:
			jobService.executeJob((JobExecutingEvent) historyEvent.getEvent());
			break;
		case Constants.JOB_FINISHED_EVENT:
			jobService.finishJob((JobFinishedEvent) historyEvent.getEvent());
			break;
		case Constants.JOB_PROGRESS_EVENT:
			jobService.progressUpdate((JobProgressEvent) historyEvent.getEvent());
			break;
		default:
			logger.warn("An unsupported event of type {} was received and discarded.", historyEvent.getEventName());
			return;
		}

		kafkaOffsetInfoService.updateOffsetInfo(partitionId, lastOffset);
	}
	
}
