/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.support.ReflectionRepositoryInvoker;

class CrudRepositoryInvoker
extends ReflectionRepositoryInvoker {
    private final CrudRepository<Object, Serializable> repository;
    private final boolean customSaveMethod;
    private final boolean customFindOneMethod;
    private final boolean customFindAllMethod;
    private final boolean customDeleteMethod;

    public CrudRepositoryInvoker(CrudRepository<Object, Serializable> repository, RepositoryMetadata metadata, ConversionService conversionService) {
        super(repository, metadata, conversionService);
        CrudMethods crudMethods = metadata.getCrudMethods();
        this.customSaveMethod = this.isRedeclaredMethod(crudMethods.getSaveMethod());
        this.customFindOneMethod = this.isRedeclaredMethod(crudMethods.getFindOneMethod());
        this.customDeleteMethod = this.isRedeclaredMethod(crudMethods.getDeleteMethod());
        this.customFindAllMethod = this.isRedeclaredMethod(crudMethods.getFindAllMethod());
        this.repository = repository;
    }

    @Override
    public Iterable<Object> invokeFindAll(Sort sort) {
        return this.customFindAllMethod ? super.invokeFindAll(sort) : this.repository.findAll();
    }

    @Override
    public Iterable<Object> invokeFindAll(Pageable pageable) {
        return this.customFindAllMethod ? super.invokeFindAll(pageable) : this.repository.findAll();
    }

    @Override
    public <T> T invokeFindOne(Serializable id) {
        return (T)(this.customFindOneMethod ? super.invokeFindOne(id) : this.repository.findOne(this.convertId(id)));
    }

    @Override
    public <T> T invokeSave(T entity) {
        return this.customSaveMethod ? super.invokeSave(entity) : this.repository.save(entity);
    }

    @Override
    public void invokeDelete(Serializable id) {
        if (this.customDeleteMethod) {
            super.invokeDelete(id);
        } else {
            this.repository.delete((Object)this.convertId(id));
        }
    }

    private boolean isRedeclaredMethod(Method method) {
        return !method.getDeclaringClass().equals(CrudRepository.class);
    }
}

