/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloud;

import org.springframework.core.env.Environment;

public enum CloudPlatform {
    CLOUD_FOUNDRY{

        @Override
        public boolean isActive(Environment environment2) {
            return environment2.containsProperty("VCAP_APPLICATION") || environment2.containsProperty("VCAP_SERVICES");
        }
    }
    ,
    HEROKU{

        @Override
        public boolean isActive(Environment environment2) {
            return environment2.containsProperty("DYNO");
        }
    };


    public abstract boolean isActive(Environment var1);

    public boolean isUsingForwardHeaders() {
        return true;
    }

    public static CloudPlatform getActive(Environment environment2) {
        if (environment2 != null) {
            for (CloudPlatform cloudPlatform : CloudPlatform.values()) {
                if (!cloudPlatform.isActive(environment2)) continue;
                return cloudPlatform;
            }
        }
        return null;
    }
}

