/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.AbstractRecordBatch;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogInputStream;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;

public class FileLogInputStream
implements LogInputStream<FileChannelRecordBatch> {
    private int position;
    private final int end;
    private final FileRecords fileRecords;
    private final ByteBuffer logHeaderBuffer = ByteBuffer.allocate(17);

    FileLogInputStream(FileRecords records, int start, int end) {
        this.fileRecords = records;
        this.position = start;
        this.end = end;
    }

    @Override
    public FileChannelRecordBatch nextBatch() throws IOException {
        FileChannel channel = this.fileRecords.channel();
        if (this.position >= this.end - 17) {
            return null;
        }
        this.logHeaderBuffer.rewind();
        Utils.readFullyOrFail(channel, this.logHeaderBuffer, this.position, "log header");
        this.logHeaderBuffer.rewind();
        long offset = this.logHeaderBuffer.getLong(0);
        int size = this.logHeaderBuffer.getInt(8);
        if (size < 14) {
            throw new CorruptRecordException(String.format("Found record size %d smaller than minimum record overhead (%d) in file %s.", size, 14, this.fileRecords.file()));
        }
        if (this.position > this.end - 12 - size) {
            return null;
        }
        byte magic = this.logHeaderBuffer.get(16);
        FileChannelRecordBatch batch = magic < 2 ? new AbstractLegacyRecordBatch.LegacyFileChannelRecordBatch(offset, magic, channel, this.position, size) : new DefaultRecordBatch.DefaultFileChannelRecordBatch(offset, magic, channel, this.position, size);
        this.position += batch.sizeInBytes();
        return batch;
    }

    public static abstract class FileChannelRecordBatch
    extends AbstractRecordBatch {
        protected final long offset;
        protected final byte magic;
        protected final FileChannel channel;
        protected final int position;
        protected final int batchSize;
        private RecordBatch fullBatch;
        private RecordBatch batchHeader;

        FileChannelRecordBatch(long offset, byte magic, FileChannel channel, int position, int batchSize) {
            this.offset = offset;
            this.magic = magic;
            this.channel = channel;
            this.position = position;
            this.batchSize = batchSize;
        }

        @Override
        public CompressionType compressionType() {
            return this.loadBatchHeader().compressionType();
        }

        @Override
        public TimestampType timestampType() {
            return this.loadBatchHeader().timestampType();
        }

        @Override
        public long checksum() {
            return this.loadBatchHeader().checksum();
        }

        @Override
        public long maxTimestamp() {
            return this.loadBatchHeader().maxTimestamp();
        }

        public int position() {
            return this.position;
        }

        @Override
        public byte magic() {
            return this.magic;
        }

        @Override
        public Iterator<Record> iterator() {
            return this.loadFullBatch().iterator();
        }

        @Override
        public CloseableIterator<Record> streamingIterator(BufferSupplier bufferSupplier) {
            return this.loadFullBatch().streamingIterator(bufferSupplier);
        }

        @Override
        public boolean isValid() {
            return this.loadFullBatch().isValid();
        }

        @Override
        public void ensureValid() {
            this.loadFullBatch().ensureValid();
        }

        @Override
        public int sizeInBytes() {
            return 12 + this.batchSize;
        }

        @Override
        public void writeTo(ByteBuffer buffer) {
            try {
                int limit = buffer.limit();
                buffer.limit(buffer.position() + this.sizeInBytes());
                Utils.readFully(this.channel, buffer, this.position);
                buffer.limit(limit);
            }
            catch (IOException e) {
                throw new KafkaException("Failed to read record batch at position " + this.position + " from file channel " + this.channel, e);
            }
        }

        protected abstract RecordBatch toMemoryRecordBatch(ByteBuffer var1);

        protected abstract int headerSize();

        protected RecordBatch loadFullBatch() {
            if (this.fullBatch == null) {
                this.batchHeader = null;
                this.fullBatch = this.loadBatchWithSize(this.sizeInBytes(), "full record batch");
            }
            return this.fullBatch;
        }

        protected RecordBatch loadBatchHeader() {
            if (this.fullBatch != null) {
                return this.fullBatch;
            }
            if (this.batchHeader == null) {
                this.batchHeader = this.loadBatchWithSize(this.headerSize(), "record batch header");
            }
            return this.batchHeader;
        }

        private RecordBatch loadBatchWithSize(int size, String description) {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(size);
                Utils.readFullyOrFail(this.channel, buffer, this.position, description);
                buffer.rewind();
                return this.toMemoryRecordBatch(buffer);
            }
            catch (IOException e) {
                throw new KafkaException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileChannelRecordBatch that = (FileChannelRecordBatch)o;
            return this.offset == that.offset && this.position == that.position && this.batchSize == that.batchSize && (this.channel == null ? that.channel == null : this.channel.equals(that.channel));
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
            result = 31 * result + this.position;
            result = 31 * result + this.batchSize;
            return result;
        }

        public String toString() {
            return "FileChannelRecordBatch(magic: " + this.magic + ", offset: " + this.offset + ", size: " + this.batchSize + ")";
        }
    }
}

