/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.util.Assert;

public class JpaMetamodel {
    private final Metamodel metamodel;
    private Collection<Class<?>> managedTypes;

    public JpaMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, "Metamodel must not be null!");
        this.metamodel = metamodel;
    }

    public boolean isJpaManaged(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        return this.getManagedTypes().contains(type);
    }

    private Collection<Class<?>> getManagedTypes() {
        if (this.managedTypes != null) {
            return this.managedTypes;
        }
        Set<ManagedType<?>> managedTypes = this.metamodel.getManagedTypes();
        HashSet types = new HashSet(managedTypes.size());
        for (ManagedType<?> managedType : this.metamodel.getManagedTypes()) {
            Class type = managedType.getJavaType();
            if (type == null) continue;
            types.add(type);
        }
        this.managedTypes = Collections.unmodifiableSet(types);
        return this.managedTypes;
    }
}

