/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service.job;

import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobInitEvent;
import br.pucrio.tecgraf.soma.job.JobProgressEvent;
import br.pucrio.tecgraf.soma.job.JobRescheduledEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.JobStageInEvent;
import br.pucrio.tecgraf.soma.job.JobStageOutEvent;
import br.pucrio.tecgraf.soma.job.JobSystemFailureEvent;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.ExecutingJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.FinishedJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.InitJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.JobProgressBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.RescheduledJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.ScheduledJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.StageInJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.StageOutJobBuilder;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.SystemFailureJobBuilder;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobByIdSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import java.io.IOException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobService {
    private final Logger logger = LoggerFactory.getLogger(JobService.class);
    private Repository<Job, JPASpecification<Job>> jobRepository;

    @Autowired
    public JobService(Repository<Job, JPASpecification<Job>> jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Transactional
    public void systemFailureJob(JobSystemFailureEvent jobSystemFailureEvent) throws IOException {
        this.logEvent(jobSystemFailureEvent.getJobId(), "JobSystemFailureEvent", jobSystemFailureEvent.getEventId());
        try {
            Job job = this.findJob(jobSystemFailureEvent.getJobId());
            new SystemFailureJobBuilder().build(job, jobSystemFailureEvent);
        }
        catch (Exception e) {
            throw this.createIOException(jobSystemFailureEvent.getJobId(), "JobSystemFailureEvent", jobSystemFailureEvent.getEventId(), e);
        }
    }

    @Transactional
    public void scheduleJob(JobScheduledEvent scheduledEvent) throws IOException {
        try {
            this.logEvent(scheduledEvent.getJobId(), "JobScheduledEvent", scheduledEvent.getEventId());
            Job job = new Job();
            new ScheduledJobBuilder().build(job, scheduledEvent);
            this.jobRepository.add(job);
        }
        catch (Exception e) {
            throw this.createIOException(scheduledEvent.getJobId(), "JobScheduledEvent", scheduledEvent.getEventId(), e);
        }
    }

    @Transactional
    public void rescheduleJob(JobRescheduledEvent rescheduledEvent) throws IOException {
        try {
            this.logEvent(rescheduledEvent.getJobId(), "JobRescheduledEvent", rescheduledEvent.getEventId());
            Job job = this.findJob(rescheduledEvent.getJobId());
            new RescheduledJobBuilder().build(job, rescheduledEvent);
        }
        catch (Exception e) {
            throw this.createIOException(rescheduledEvent.getJobId(), "JobRescheduledEvent", rescheduledEvent.getEventId(), e);
        }
    }

    @Transactional
    public void initJob(JobInitEvent jobInitEvent) throws IOException {
        this.logEvent(jobInitEvent.getJobId(), "JobInitEvent", jobInitEvent.getEventId());
        try {
            Job job = this.findJob(jobInitEvent.getJobId());
            new InitJobBuilder().build(job, jobInitEvent);
        }
        catch (Exception e) {
            throw this.createIOException(jobInitEvent.getJobId(), "JobInitEvent", jobInitEvent.getEventId(), e);
        }
    }

    @Transactional
    public void stageJobIn(JobStageInEvent stageInEvent) throws IOException {
        this.logEvent(stageInEvent.getJobId(), "JobStageInEvent", stageInEvent.getEventId());
        try {
            Job job = this.findJob(stageInEvent.getJobId());
            new StageInJobBuilder().build(job, stageInEvent);
        }
        catch (Exception e) {
            throw this.createIOException(stageInEvent.getJobId(), "JobStageInEvent", stageInEvent.getEventId(), e);
        }
    }

    @Transactional
    public void stageJobOut(JobStageOutEvent stageOutEvent) throws IOException {
        this.logEvent(stageOutEvent.getJobId(), "JobStageOutEvent", stageOutEvent.getEventId());
        try {
            Job job = this.findJob(stageOutEvent.getJobId());
            new StageOutJobBuilder().build(job, stageOutEvent);
        }
        catch (Exception e) {
            throw this.createIOException(stageOutEvent.getJobId(), "JobStageOutEvent", stageOutEvent.getEventId(), e);
        }
    }

    @Transactional
    public void executeJob(JobExecutingEvent executingEvent) throws IOException {
        this.logEvent(executingEvent.getJobId(), "JobExecutingEvent", executingEvent.getEventId());
        try {
            Job job = this.findJob(executingEvent.getJobId());
            new ExecutingJobBuilder().build(job, executingEvent);
        }
        catch (Exception e) {
            throw this.createIOException(executingEvent.getJobId(), "JobExecutingEvent", executingEvent.getEventId(), e);
        }
    }

    @Transactional
    public void finishJob(JobFinishedEvent finishedEvent) throws IOException {
        this.logEvent(finishedEvent.getJobId(), "JobFinishedEvent", finishedEvent.getEventId());
        try {
            Job job = this.findJob(finishedEvent.getJobId());
            new FinishedJobBuilder().build(job, finishedEvent);
        }
        catch (Exception e) {
            throw this.createIOException(finishedEvent.getJobId(), "JobFinishedEvent", finishedEvent.getEventId(), e);
        }
    }

    @Transactional
    public void progressUpdate(JobProgressEvent progressEvent) throws IOException {
        this.logEvent(progressEvent.getJobId(), "JobProgressEvent", progressEvent.getEventId());
        try {
            Job job = this.findJob(progressEvent.getJobId());
            new JobProgressBuilder().build(job, progressEvent);
        }
        catch (Exception e) {
            throw this.createIOException(progressEvent.getJobId(), "JobProgressEvent", progressEvent.getEventId(), e);
        }
    }

    private Job findJob(String jobId) {
        Job job = this.jobRepository.first(new JobByIdSpecification(jobId));
        if (job == null) {
            throw new RuntimeException("Cannot find a job with JobId= " + jobId + ".");
        }
        return job;
    }

    private void logEvent(String jobId, String eventType, String eventId) {
        this.logger.info("[Job={}, event type={}, event id={}]", jobId, eventType, eventId);
    }

    private IOException createIOException(String jobId, String eventType, String eventId, Exception e) {
        return new IOException(MessageFormat.format("Error processing event type {0} for job {1}. [event id={2}].", eventType, jobId, eventId), e);
    }
}

