/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.HashSet;
import org.modelmapper.convention.InexactMatcher;
import org.modelmapper.spi.MatchingStrategy;
import org.modelmapper.spi.PropertyNameInfo;
import org.modelmapper.spi.Tokens;

final class StandardMatchingStrategy
implements MatchingStrategy {
    StandardMatchingStrategy() {
    }

    @Override
    public boolean matches(PropertyNameInfo propertyNameInfo) {
        return new Matcher(propertyNameInfo).match();
    }

    @Override
    public boolean isExact() {
        return false;
    }

    public String toString() {
        return "Standard";
    }

    static class Matcher
    extends InexactMatcher {
        Matcher(PropertyNameInfo propertyNameInfo) {
            super(propertyNameInfo);
        }

        boolean match() {
            HashSet<Integer> matchSources = new HashSet<Integer>();
            for (Tokens destTokens : this.propertyNameInfo.getDestinationPropertyTokens()) {
                int destTokenIndex = 0;
                while (destTokenIndex < destTokens.size()) {
                    InexactMatcher.DestTokensMatcher matchedTokens = this.matchSourcePropertyName(destTokens, destTokenIndex);
                    if (matchedTokens.match()) {
                        destTokenIndex += matchedTokens.maxMatchTokens();
                        matchSources.addAll(matchedTokens.matchSources());
                        continue;
                    }
                    if (this.matchSourcePropertyType(destTokens.token(destTokenIndex)) || this.matchSourceClass(destTokens.token(destTokenIndex))) {
                        ++destTokenIndex;
                        continue;
                    }
                    return false;
                }
            }
            return matchSources.size() == this.sourceTokens.size();
        }
    }
}

