/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.transaction.PlatformTransactionManagerCustomizer;
import org.springframework.core.ResolvableType;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionManagerCustomizers {
    private static final Log logger = LogFactory.getLog(TransactionManagerCustomizers.class);
    private final List<PlatformTransactionManagerCustomizer<?>> customizers;

    public TransactionManagerCustomizers(Collection<? extends PlatformTransactionManagerCustomizer<?>> customizers) {
        this.customizers = customizers == null ? null : new ArrayList(customizers);
    }

    public void customize(PlatformTransactionManager transactionManager) {
        if (this.customizers != null) {
            for (PlatformTransactionManagerCustomizer<?> customizer2 : this.customizers) {
                Class<?> generic = ResolvableType.forClass(PlatformTransactionManagerCustomizer.class, customizer2.getClass()).resolveGeneric(new int[0]);
                if (!generic.isInstance(transactionManager)) continue;
                this.customize(transactionManager, customizer2);
            }
        }
    }

    private void customize(PlatformTransactionManager transactionManager, PlatformTransactionManagerCustomizer customizer2) {
        block2: {
            try {
                customizer2.customize(transactionManager);
            }
            catch (ClassCastException ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Non-matching transaction manager type for customizer: " + customizer2, ex);
            }
        }
    }
}

