/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.Assert;

public class CachingIsNewStrategyFactory
implements IsNewStrategyFactory {
    private final Map<Class<?>, IsNewStrategy> cache = new ConcurrentHashMap();
    private final IsNewStrategyFactory delegate;

    public CachingIsNewStrategyFactory(IsNewStrategyFactory delegate) {
        Assert.notNull((Object)delegate, "IsNewStrategyFactory delegate must not be null!");
        this.delegate = delegate;
    }

    @Override
    public IsNewStrategy getIsNewStrategy(Class<?> type) {
        IsNewStrategy strategy = this.cache.get(type);
        if (strategy != null) {
            return strategy;
        }
        IsNewStrategy isNewStrategy = this.delegate.getIsNewStrategy(type);
        this.cache.put(type, isNewStrategy);
        return isNewStrategy;
    }
}

