package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.JobSystemFailureEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.SystemFailureJobMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;

public class SystemFailureJobBuilder extends AbstractJobBuilder {

  public void build(Job job, JobSystemFailureEvent event) {
    SystemFailureJobMapper.getInstance().map(event, job);

    JobStatusHistory jobStatusHistory =
        newJobStatusHistory(StatusType.SYSTEM_FAILURE, event.getTimestamp());
    job.addStatusHistory(jobStatusHistory);
  }
}
