package br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification;

import br.pucrio.tecgraf.soma.job.domain.model.KafkaOffsetInfo;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class KafkaOffsetInfoByIdSpecification extends JPASpecification<KafkaOffsetInfo> {

  private int partitionId;

  public KafkaOffsetInfoByIdSpecification(int partitionId) {
    this.partitionId = partitionId;
  }

  public boolean isSatisfiedBy(KafkaOffsetInfo element) {
    return element.getPartitionId() == partitionId;
  }

  @Override
  public Predicate toPredicate(Root<KafkaOffsetInfo> root, CriteriaBuilder cb) {
    return cb.equal(root.get("partitionId"), partitionId);
  }

  @Override
  public Class<KafkaOffsetInfo> getType() {
    return KafkaOffsetInfo.class;
  }
}
